/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public final class UserToken
implements Writeable,
ToXContentObject {
    private final Version version;
    private final String id;
    private final Authentication authentication;
    private final Instant expirationTime;
    private final Map<String, Object> metadata;

    UserToken(Authentication authentication, Instant expirationTime) {
        this(Version.CURRENT, authentication, expirationTime, Collections.emptyMap());
    }

    private UserToken(Version version, Authentication authentication, Instant expirationTime, Map<String, Object> metadata) {
        this(UUIDs.randomBase64UUID(), version, authentication, expirationTime, metadata);
    }

    UserToken(String id, Version version, Authentication authentication, Instant expirationTime, Map<String, Object> metadata) {
        this.version = Objects.requireNonNull(version);
        this.id = Objects.requireNonNull(id);
        this.authentication = Objects.requireNonNull(authentication);
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.metadata = metadata;
    }

    UserToken(StreamInput input) throws IOException {
        this.version = input.getVersion();
        this.id = input.readString();
        this.authentication = new Authentication(input);
        this.expirationTime = Instant.ofEpochSecond(input.readLong(), input.readInt());
        this.metadata = input.readMap();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        this.authentication.writeTo(out);
        out.writeLong(this.expirationTime.getEpochSecond());
        out.writeInt(this.expirationTime.getNano());
        out.writeMap(this.metadata);
    }

    Authentication getAuthentication() {
        return this.authentication;
    }

    Instant getExpirationTime() {
        return this.expirationTime;
    }

    public String getId() {
        return this.id;
    }

    Version getVersion() {
        return this.version;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("expiration_time", this.expirationTime.toEpochMilli());
        builder.field("version", this.version.id);
        builder.field("metadata", this.metadata);
        try (BytesStreamOutput output = new BytesStreamOutput();){
            output.setVersion(this.version);
            this.authentication.writeTo((StreamOutput)output);
            builder.field("authentication", output.bytes().toBytesRef().bytes);
        }
        return builder.endObject();
    }

    static UserToken fromSourceMap(Map<String, Object> source) throws IllegalStateException, DateTimeException {
        UserToken userToken;
        block12: {
            String id = (String)source.get("id");
            if (id == null) {
                throw new IllegalStateException("user token source document does not have the \"id\" field");
            }
            Long expirationEpochMilli = (Long)source.get("expiration_time");
            if (expirationEpochMilli == null) {
                throw new IllegalStateException("user token source document does not have the \"expiration_time\" field");
            }
            Integer versionId = (Integer)source.get("version");
            if (versionId == null) {
                throw new IllegalStateException("user token source document does not have the \"version\" field");
            }
            Map metadata = (Map)source.get("metadata");
            String authString = (String)source.get("authentication");
            if (authString == null) {
                throw new IllegalStateException("user token source document does not have the \"authentication\" field");
            }
            Version version = Version.fromId((int)versionId);
            StreamInput in = StreamInput.wrap((byte[])Base64.getDecoder().decode(authString));
            try {
                in.setVersion(version);
                Authentication authentication = new Authentication(in);
                userToken = new UserToken(id, version, authentication, Instant.ofEpochMilli(expirationEpochMilli), metadata);
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("user token source document contains malformed \"authentication\" field", e);
                }
            }
            in.close();
        }
        return userToken;
    }
}

