/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.privilege;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;

public class TransportGetPrivilegesAction
extends HandledTransportAction<GetPrivilegesRequest, GetPrivilegesResponse> {
    private final NativePrivilegeStore privilegeStore;

    @Inject
    public TransportGetPrivilegesAction(ActionFilters actionFilters, NativePrivilegeStore privilegeStore, TransportService transportService) {
        super("cluster:admin/xpack/security/privilege/get", transportService, actionFilters, GetPrivilegesRequest::new);
        this.privilegeStore = privilegeStore;
    }

    protected void doExecute(Task task, GetPrivilegesRequest request, ActionListener<GetPrivilegesResponse> listener) {
        HashSet<String> names = request.privileges() == null || request.privileges().length == 0 ? null : new HashSet<String>(Arrays.asList(request.privileges()));
        Set<String> applications = Strings.isNullOrEmpty((String)request.application()) ? null : Collections.singleton(request.application());
        this.privilegeStore.getPrivileges(applications, names, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(privileges -> listener.onResponse((Object)new GetPrivilegesResponse(privileges)), arg_0 -> listener.onFailure(arg_0)));
    }
}

