/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.processor;

import java.io.IOException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.ql.expression.gen.processor.BinaryProcessor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public abstract class FunctionalBinaryProcessor<T, U, R, F extends BiFunction<T, U, R>>
extends BinaryProcessor {
    private final F function;

    protected FunctionalBinaryProcessor(Processor left, Processor right, F function) {
        super(left, right);
        this.function = function;
    }

    protected FunctionalBinaryProcessor(StreamInput in, Writeable.Reader<F> reader) throws IOException {
        super(in);
        this.function = (BiFunction)reader.read(in);
    }

    public F function() {
        return this.function;
    }

    @Override
    protected Object doProcess(Object left, Object right) {
        return this.function.apply((Object)left, (Object)right);
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.function());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionalBinaryProcessor other = (FunctionalBinaryProcessor)obj;
        return Objects.equals(this.function(), other.function()) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }
}

