/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class EqlStatsRequest
extends BaseNodesRequest<EqlStatsRequest> {
    private boolean includeStats;

    public EqlStatsRequest() {
        super((String[])null);
    }

    public EqlStatsRequest(StreamInput in) throws IOException {
        super(in);
        this.includeStats = in.readBoolean();
    }

    public boolean includeStats() {
        return this.includeStats;
    }

    public void includeStats(boolean includeStats) {
        this.includeStats = includeStats;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.includeStats);
    }

    public String toString() {
        return "eql_stats";
    }

    static class NodeStatsRequest
    extends TransportRequest {
        boolean includeStats;

        NodeStatsRequest(StreamInput in) throws IOException {
            super(in);
            this.includeStats = in.readBoolean();
        }

        NodeStatsRequest(EqlStatsRequest request) {
            this.includeStats = request.includeStats();
        }

        public boolean includeStats() {
            return this.includeStats;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.includeStats);
        }
    }
}

