#pragma once
// 
// Copyright (c) 1998, 2005 Macromedia, inc.  All Rights Reserved.
// ---------------------------------------------------------
//
// MMInfo.h
//
#ifndef _MMINFO_H_
#define _MMINFO_H_

#ifdef _WIN32	// Windows
	#define MMNOTES_EXPORT	__declspec( dllexport )
#else    // Codewarrior/Mac
	#define MMNOTES_EXPORT	extern
	typedef int BOOL;
	#ifdef TRUE
		#undef TRUE
	#endif
	#ifdef FALSE
		#undef FALSE
	#endif
	#define TRUE true
	#define FALSE false

	#ifdef __cplusplus
	extern "C" {
	#endif

	#pragma export on    
#endif

typedef int FileHandle;
typedef char InfoKey[64];
typedef wchar_t InfoKeyW[64];

struct InfoPrefs
{
	BOOL bUseDesignNotes;
	BOOL bUploadDesignNotes;
};

// Declare the external entry point and linkage
MMNOTES_EXPORT FileHandle OpenNotesFile( const char* mediaFilePath, BOOL bForce=FALSE );
MMNOTES_EXPORT FileHandle OpenNotesFileWithOpenFlags( const char* mediaFilePath, BOOL bForce=FALSE, BOOL bReadOnly=FALSE );
MMNOTES_EXPORT void CloseNotesFile( FileHandle infoHandle );
MMNOTES_EXPORT BOOL SetNote( FileHandle infoHandle, const InfoKey key, const char* value );
MMNOTES_EXPORT BOOL RemoveNote( FileHandle infoHandle, const InfoKey key );
MMNOTES_EXPORT int GetNoteLength( FileHandle infoHandle, const InfoKey key );
MMNOTES_EXPORT BOOL GetNote( FileHandle infoHandle, const InfoKey key, char* valueBuf, int valueBufMaxLen );
MMNOTES_EXPORT int	 GetNotesKeyCount( FileHandle infoHandle );
MMNOTES_EXPORT BOOL GetNotesKeys( FileHandle infoHandle, InfoKey* keyList, int keyListMaxLen );
MMNOTES_EXPORT BOOL GetSiteRootForFile( const char* mediaFilePath, char* siteRootBuf, int siteRootBufMaxLen, InfoPrefs* prefs=NULL );
MMNOTES_EXPORT BOOL GetVersionNum( char* versionNumBuf, int versionNumBufMaxLen );
MMNOTES_EXPORT BOOL GetVersionName( char* versionNameBuf, int versionNameBufMaxLen );
MMNOTES_EXPORT BOOL FilePathToLocalURL( const char* filePath, char* localURL, int localURLMaxLen );
MMNOTES_EXPORT BOOL LocalURLToFilePath( const char* localURL, char* filePath, int filePathMaxLen );

//Wide versions of the entry points
MMNOTES_EXPORT FileHandle OpenNotesFileW( const wchar_t* mediaFilePath, BOOL bForce=FALSE );
MMNOTES_EXPORT FileHandle OpenNotesFileWithOpenFlagsW( const wchar_t* mediaFilePath, BOOL bForce=FALSE, BOOL bReadOnly=FALSE );
MMNOTES_EXPORT void CloseNotesFileW( FileHandle infoHandle );
MMNOTES_EXPORT BOOL SetNoteW( FileHandle infoHandle, const InfoKeyW key, const wchar_t* value );
MMNOTES_EXPORT BOOL RemoveNoteW( FileHandle infoHandle, const InfoKeyW key );
MMNOTES_EXPORT int GetNoteLengthW( FileHandle infoHandle, const InfoKeyW key );
MMNOTES_EXPORT BOOL GetNoteW( FileHandle infoHandle, const InfoKeyW key, wchar_t* valueBuf, int valueBufMaxLen );
MMNOTES_EXPORT int	 GetNotesKeyCountW( FileHandle infoHandle );
MMNOTES_EXPORT BOOL GetNotesKeysW( FileHandle infoHandle, InfoKeyW* keyList, int keyListMaxLen );
MMNOTES_EXPORT BOOL GetSiteRootForFileW( const wchar_t* mediaFilePath, wchar_t* siteRootBuf, int siteRootBufMaxLen, InfoPrefs* prefs=NULL );
MMNOTES_EXPORT BOOL GetVersionNumW( wchar_t* versionNumBuf, int versionNumBufMaxCount );
MMNOTES_EXPORT BOOL GetVersionNameW( wchar_t* versionNameBuf, int versionNameBufMaxCount );
MMNOTES_EXPORT BOOL FilePathToLocalURLW( const wchar_t* filePath, wchar_t* localURL, int localURLMaxCount );
MMNOTES_EXPORT BOOL LocalURLToFilePathW( const wchar_t* localURL, wchar_t* filePath, int filePathMaxCount );


#ifndef _WIN32
	#pragma export off

	#ifdef __cplusplus
	}
	#endif
#endif

// Exported functions

JSBool
openInfo( JSContext* cx, JSObject* obj, unsigned int  argc
             , jsval* jsArgv, jsval* rval );
JSBool
closeInfo( JSContext* cx, JSObject* obj, unsigned int  argc
             , jsval* jsArgv, jsval* rval );
JSBool
set( JSContext* cx, JSObject* obj, unsigned int  argc
             , jsval* jsArgv, jsval* rval );
JSBool
remove( JSContext* cx, JSObject* obj, unsigned int  argc
        , jsval* jsArgv, jsval* rval );
JSBool
getLength( JSContext* cx, JSObject* obj, unsigned int  argc
         , jsval* jsArgv, jsval* rval );
JSBool
get( JSContext* cx, JSObject* obj, unsigned int  argc
        , jsval* jsArgv, jsval* rval );
JSBool
getKeyCount( JSContext* cx, JSObject* obj, unsigned int  argc
         , jsval* jsArgv, jsval* rval );
JSBool
getKeys( JSContext* cx, JSObject* obj, unsigned int  argc
            , jsval* jsArgv, jsval* rval );
JSBool
getSiteRootForFile( JSContext* cx, JSObject* obj, unsigned int  argc
          , jsval* jsArgv, jsval* rval );
JSBool
getVersionNum( JSContext* cx, JSObject* obj, unsigned int  argc
          , jsval* jsArgv, jsval* rval );
JSBool
getVersionName( JSContext* cx, JSObject* obj, unsigned int  argc
          , jsval* jsArgv, jsval* rval );
JSBool
filePathToLocalURL( JSContext* cx, JSObject* obj, unsigned int  argc
          , jsval* jsArgv, jsval* rval );
JSBool
localURLToFilePath( JSContext* cx, JSObject* obj, unsigned int  argc
          , jsval* jsArgv, jsval* rval );

void
MM_Init( void );

#endif

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//	LOG 
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//	20-sep-99	hbauer		Changed function names to use the word Notes 
//							instead of Info.