/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode.lowlevel;

import com.techtrader.modules.tools.bytecode.lowlevel.Entry;
import com.techtrader.modules.tools.bytecode.lowlevel.LowLevelConstants;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NameAndTypeEntry
implements Entry,
LowLevelConstants {
    private int _nameIndex = 0;
    private int _descriptorIndex = 0;

    public int getType() {
        return 12;
    }

    public int getNameIndex() {
        return this._nameIndex;
    }

    public void setNameIndex(int n) {
        this._nameIndex = n;
    }

    public int getDescriptorIndex() {
        return this._descriptorIndex;
    }

    public void setDescriptorIndex(int n) {
        this._descriptorIndex = n;
    }

    public void readData(DataInput dataInput) throws IOException {
        this.setNameIndex(dataInput.readUnsignedShort());
        this.setDescriptorIndex(dataInput.readUnsignedShort());
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getNameIndex());
        dataOutput.writeShort(this.getDescriptorIndex());
    }

    public String getKey() {
        return this.getType() + "|" + this.getNameIndex() + "|" + this.getDescriptorIndex();
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterNameAndTypeEntry(this);
        bCVisitor.exitNameAndTypeEntry(this);
    }
}

