/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode.lowlevel;

import com.techtrader.modules.tools.bytecode.lowlevel.ConstantEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.LowLevelConstants;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FloatEntry
implements ConstantEntry,
LowLevelConstants {
    private float _value = 0.0f;

    public int getType() {
        return 4;
    }

    public float getValue() {
        return this._value;
    }

    public void setValue(float f) {
        this._value = f;
    }

    public Object getConstantValue() {
        return new Float(this._value);
    }

    public void setConstantValue(Object object) {
        this._value = ((Number)object).floatValue();
    }

    public void readData(DataInput dataInput) throws IOException {
        this.setValue(dataInput.readFloat());
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.getValue());
    }

    public String getKey() {
        return this.getType() + "|" + this.getValue();
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterFloatEntry(this);
        bCVisitor.exitFloatEntry(this);
    }
}

