/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.BCHelper;
import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.InstructionPtr;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ExceptionHandler
implements InstructionPtr {
    private int _startPc = 0;
    private int _endPc = 0;
    private int _handlerPc = 0;
    private int _catchTypeIndex = 0;
    private Code _owner = null;
    private Instruction _start = null;
    private Instruction _end = null;
    private Instruction _handler = null;

    protected void invalidate() {
        this._owner = null;
    }

    public int getStartPc() {
        if (this._start != null) {
            return this._start.getByteIndex();
        }
        return this._startPc;
    }

    public void setStartPc(int n) {
        this._startPc = n;
        this._start = null;
    }

    public void setTryStart(Instruction instruction) {
        this._start = instruction;
    }

    public Instruction getTryStart() {
        return this._start;
    }

    public int getEndPc() {
        if (this._end != null) {
            return this._end.getByteIndex() + this._end.getLength();
        }
        return this._endPc;
    }

    public void setEndPc(int n) {
        this._endPc = n;
        this._end = null;
    }

    public void setTryEnd(Instruction instruction) {
        this._end = instruction;
    }

    public Instruction getTryEnd() {
        return this._end;
    }

    public int getHandlerPc() {
        if (this._handler != null) {
            return this._handler.getByteIndex();
        }
        return this._handlerPc;
    }

    public void setHandlerPc(int n) {
        this._handlerPc = n;
        this._handler = null;
    }

    public void setHandlerStart(Instruction instruction) {
        this._handler = instruction;
    }

    public Instruction getHandlerStart() {
        return this._handler;
    }

    public int getCatchTypeIndex() {
        return this._catchTypeIndex;
    }

    public void setCatchTypeIndex(int n) {
        this._catchTypeIndex = n;
    }

    public String getCatchTypeName() {
        if (this._catchTypeIndex == 0) {
            return null;
        }
        return BCHelper.getExternalForm(this._owner.getPool().getClassName(this._catchTypeIndex), true);
    }

    public void setCatchTypeName(String string) {
        this._catchTypeIndex = string == null ? 0 : this._owner.getPool().setClassName(0, BCHelper.getInternalForm(string, false));
    }

    public Class getCatchType() throws ClassNotFoundException {
        if (this._catchTypeIndex == 0) {
            return null;
        }
        return BCHelper.classForName(this._owner.getPool().getClassName(this._catchTypeIndex));
    }

    public void setCatchType(Class clazz) {
        if (clazz == null) {
            this.setCatchTypeName(null);
        } else {
            this.setCatchTypeName(clazz.getName());
        }
    }

    public void setMarkers(List list) {
        Instruction instruction = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instruction instruction2 = instruction;
            instruction = (Instruction)iterator.next();
            if (instruction.getByteIndex() == this._startPc) {
                this.setTryStart(instruction);
            }
            if (instruction.getByteIndex() == this._endPc) {
                this.setTryEnd(instruction2);
            }
            if (instruction.getByteIndex() != this._handlerPc) continue;
            this.setHandlerStart(instruction);
        }
    }

    protected void copy(ExceptionHandler exceptionHandler) {
        this.setStartPc(exceptionHandler.getStartPc());
        this.setEndPc(exceptionHandler.getEndPc());
        this.setHandlerPc(exceptionHandler.getHandlerPc());
        this.setCatchTypeName(exceptionHandler.getCatchTypeName());
    }

    protected void readData(DataInput dataInput) throws IOException {
        this.setStartPc(dataInput.readUnsignedShort());
        this.setEndPc(dataInput.readUnsignedShort());
        this.setHandlerPc(dataInput.readUnsignedShort());
        this.setCatchTypeIndex(dataInput.readUnsignedShort());
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getStartPc());
        dataOutput.writeShort(this.getEndPc());
        dataOutput.writeShort(this.getHandlerPc());
        dataOutput.writeShort(this.getCatchTypeIndex());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterExceptionHandler(this);
        bCVisitor.exitExceptionHandler(this);
    }

    protected ExceptionHandler(Code code) {
        this._owner = code;
    }
}

