/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.utils;

import com.macromedia.generator.utils.GenReportFrame;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;

public class GenReport {
    private String[] keys = null;
    public static final int KEY_COUNT = 31;
    public static final int BEGIN = 0;
    public static final int START_TIME = 1;
    public static final int CUR_TIME = 2;
    public static final int STAT_TIME = 3;
    public static final int MAX_REQUESTS = 4;
    public static final int SWF_CNT = 5;
    public static final int SWF_AVG_SIZE = 6;
    public static final int SWF_AVG_TIME = 7;
    public static final int SWF_MAX_SIZE = 8;
    public static final int SWF_MAX_TIME = 9;
    public static final int GIF_CNT = 10;
    public static final int GIF_AVG_SIZE = 11;
    public static final int GIF_AVG_TIME = 12;
    public static final int GIF_MAX_SIZE = 13;
    public static final int GIF_MAX_TIME = 14;
    public static final int JPG_CNT = 15;
    public static final int JPG_AVG_SIZE = 16;
    public static final int JPG_AVG_TIME = 17;
    public static final int JPG_MAX_SIZE = 18;
    public static final int JPG_MAX_TIME = 19;
    public static final int PNG_CNT = 20;
    public static final int PNG_AVG_SIZE = 21;
    public static final int PNG_AVG_TIME = 22;
    public static final int PNG_MAX_SIZE = 23;
    public static final int PNG_MAX_TIME = 24;
    public static final int QTM_CNT = 25;
    public static final int QTM_AVG_SIZE = 26;
    public static final int QTM_AVG_TIME = 27;
    public static final int QTM_MAX_SIZE = 28;
    public static final int QTM_MAX_TIME = 29;
    public static final int END = 30;
    GenReportFrame reportList = null;
    GenReportFrame reportLast = null;
    public GenReportFrame results30 = null;
    public GenReportFrame results60 = null;
    public GenReportFrame results90 = null;
    public GenReportFrame resultsCurrent = null;
    private long mOneDay = 86400000L;
    private int mDaysBack = 0;
    private boolean mDebugLogging = false;

    public GenReport() {
        this.loadKeys();
    }

    public boolean loadKeys() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.macromedia.generator.resources.ResourceData", Locale.getDefault());
        if (resourceBundle == null) {
            return false;
        }
        this.keys = new String[31];
        this.keys[0] = resourceBundle.getString("GenStats").trim();
        this.keys[1] = resourceBundle.getString("GenStatsStartup").trim();
        this.keys[2] = resourceBundle.getString("GenStatsCurTime").trim();
        this.keys[3] = resourceBundle.getString("GenStatsStatTime").trim();
        this.keys[4] = resourceBundle.getString("GenStatsMaxReq").trim();
        this.keys[5] = resourceBundle.getString("GenStatsSwfCnt").trim();
        this.keys[6] = resourceBundle.getString("GenStatsSwfAvgSz").trim();
        this.keys[7] = resourceBundle.getString("GenStatsSwfAvgTime").trim();
        this.keys[8] = resourceBundle.getString("GenStatsSwfMaxSz").trim();
        this.keys[9] = resourceBundle.getString("GenStatsSwfMaxTime").trim();
        this.keys[10] = resourceBundle.getString("GenStatsGifCnt").trim();
        this.keys[11] = resourceBundle.getString("GenStatsGifAvgSz").trim();
        this.keys[12] = resourceBundle.getString("GenStatsGifAvgTime").trim();
        this.keys[13] = resourceBundle.getString("GenStatsGifMaxSz").trim();
        this.keys[14] = resourceBundle.getString("GenStatsGifMaxTime").trim();
        this.keys[15] = resourceBundle.getString("GenStatsJpgCnt").trim();
        this.keys[16] = resourceBundle.getString("GenStatsJpgAvgSz").trim();
        this.keys[17] = resourceBundle.getString("GenStatsJpgAvgTime").trim();
        this.keys[18] = resourceBundle.getString("GenStatsJpgMaxSz").trim();
        this.keys[19] = resourceBundle.getString("GenStatsJpgMaxTime").trim();
        this.keys[20] = resourceBundle.getString("GenStatsPngCnt").trim();
        this.keys[21] = resourceBundle.getString("GenStatsPngAvgSz").trim();
        this.keys[22] = resourceBundle.getString("GenStatsPngAvgTime").trim();
        this.keys[23] = resourceBundle.getString("GenStatsPngMaxSz").trim();
        this.keys[24] = resourceBundle.getString("GenStatsPngMaxTime").trim();
        this.keys[25] = resourceBundle.getString("GenStatsQTMCnt").trim();
        this.keys[26] = resourceBundle.getString("GenStatsQTMAvgSz").trim();
        this.keys[27] = resourceBundle.getString("GenStatsQTMAvgTime").trim();
        this.keys[28] = resourceBundle.getString("GenStatsQTMMaxSz").trim();
        this.keys[29] = resourceBundle.getString("GenStatsQTMMaxTime").trim();
        this.keys[30] = resourceBundle.getString("EndGenStats").trim();
        return true;
    }

    public boolean loadStats(String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bufferedReader == null) {
            return false;
        }
        long l = 0L;
        GenReportFrame genReportFrame = this.readFrame(bufferedReader);
        while (genReportFrame != null) {
            genReportFrame.prev = this.reportLast;
            if (this.reportLast != null) {
                this.reportLast.next = genReportFrame;
            }
            if (this.reportList == null) {
                this.reportList = genReportFrame;
            }
            this.reportLast = genReportFrame;
            long l2 = genReportFrame.getMidTime();
            if (l2 < l) {
                this.DebugOut("something goofy about the times here. " + l + " > " + l2);
            }
            l = l2;
            genReportFrame = this.readFrame(bufferedReader);
        }
        this.tallyResults();
        return true;
    }

    public void setReportLog(boolean bl) {
        this.mDebugLogging = bl;
    }

    public boolean setTimeFrame(String string) {
        if (string.equalsIgnoreCase("sec")) {
            this.mOneDay = 1000L;
        } else if (string.equalsIgnoreCase("min")) {
            this.mOneDay = 60000L;
        } else if (string.equalsIgnoreCase("hour")) {
            this.mOneDay = 3600000L;
        } else if (string.equalsIgnoreCase("day")) {
            this.mOneDay = 86400000L;
        } else {
            return false;
        }
        this.DebugOut("Time frame set to: " + string);
        return true;
    }

    public boolean setDaysBack(int n) {
        if (n < 0) {
            return false;
        }
        this.mDaysBack = n;
        return true;
    }

    protected GenReportFrame readFrame(BufferedReader bufferedReader) {
        GenReportFrame genReportFrame = null;
        try {
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            genReportFrame = new GenReportFrame();
            if (!genReportFrame.parseReadString(string)) {
                genReportFrame = null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (genReportFrame != null) {
            this.DebugOut("readFrame: " + genReportFrame.getMidTime() + " delta time: " + genReportFrame.statTime);
        }
        return genReportFrame;
    }

    private void tallyResults() {
        String string;
        if (this.reportList == null) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = (l -= this.mOneDay * (long)this.mDaysBack) - 30L * this.mOneDay;
        long l3 = l - 60L * this.mOneDay;
        long l4 = l - 90L * this.mOneDay;
        this.results30 = new GenReportFrame();
        this.results60 = new GenReportFrame();
        this.results90 = new GenReportFrame();
        this.resultsCurrent = new GenReportFrame();
        this.DebugOut("Tally current set");
        GenReportFrame genReportFrame = this.reportLast;
        this.resultsCurrent.startupTime = string = genReportFrame.startupTime;
        while (genReportFrame != null && string != null && genReportFrame.startupTime != null && string.equals(genReportFrame.startupTime)) {
            this.describeFrame(genReportFrame, l);
            this.resultsCurrent.mergeFrame(genReportFrame);
            genReportFrame = genReportFrame.prev;
        }
        this.DebugOut(" ");
        this.DebugOut("Purge for daysback: " + l);
        genReportFrame = this.reportLast;
        long l5 = 0L;
        while (genReportFrame != null) {
            l5 = genReportFrame.currentTime + (genReportFrame.statTime >> 1);
            if (l5 <= l) break;
            this.describeFrame(genReportFrame, l);
            GenReportFrame genReportFrame2 = genReportFrame.prev;
            if (genReportFrame2 != null) {
                genReportFrame.prev = null;
                genReportFrame2.next = null;
            }
            this.reportLast = genReportFrame2;
            if (this.reportLast == null) {
                this.reportList = null;
            }
            genReportFrame = genReportFrame2;
        }
        this.DebugOut(" ");
        this.DebugOut("Tally 30 Days, " + l2);
        genReportFrame = this.reportLast;
        while (genReportFrame != null) {
            l5 = genReportFrame.currentTime + (genReportFrame.statTime >> 1);
            if (l5 < l2) break;
            this.describeFrame(genReportFrame, l);
            this.results30.mergeFrame(genReportFrame);
            genReportFrame = genReportFrame.prev;
        }
        this.DebugOut(" ");
        this.DebugOut("Tally 60 Days: " + l3);
        while (genReportFrame != null) {
            l5 = genReportFrame.currentTime + (genReportFrame.statTime >> 1);
            if (l5 < l3) break;
            this.describeFrame(genReportFrame, l);
            this.results60.mergeFrame(genReportFrame);
            genReportFrame = genReportFrame.prev;
        }
        this.DebugOut(" ");
        this.DebugOut("Tally 90 Days: " + l4);
        while (genReportFrame != null) {
            l5 = genReportFrame.currentTime + (genReportFrame.statTime >> 1);
            if (l5 < l4) break;
            this.describeFrame(genReportFrame, l);
            this.results90.mergeFrame(genReportFrame);
            genReportFrame = genReportFrame.prev;
        }
    }

    private void describeFrame(GenReportFrame genReportFrame, long l) {
        if (!this.mDebugLogging) {
            return;
        }
        long l2 = genReportFrame.getMidTime();
        this.DebugOut("mid time: " + l2 + ", gifCnt: " + genReportFrame.gifCnt + ", totSize: " + genReportFrame.gifTotSize + ", totTime: " + genReportFrame.gifTotTime);
    }

    private void DebugOut(String string) {
        if (!this.mDebugLogging) {
            return;
        }
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("com.macromedia.generator.installpath");
        String string4 = string3 + string2 + "logs" + string2 + "GenReportDebug.log";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string4, true);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(string);
            printWriter.flush();
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

