/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.utils;

import com.macromedia.generator.api.Context;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.Script;
import com.macromedia.generator.app.CacheManager;
import com.macromedia.generator.app.FlashEnvironment;
import com.macromedia.generator.app.GenVector;
import com.macromedia.generator.platform.Mac;
import com.macromedia.generator.utils.ChartPeer;
import com.macromedia.generator.utils.PropertyParser;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;

public class Chart
extends GenObject {
    Context gContext;
    FlashEnvironment gEnv;
    String gClassName = null;
    public static final int VALUE_NEVER = 0;
    public static final int VALUE_ALWAYS = 1;
    public static final int VALUE_ROLLOVER = 2;
    public static final int VALUE_PLACE_ON_BAR = 0;
    public static final int VALUE_PLACE_OVER_BAR = 1;
    public static final int VALUE_PLACE_OVER_CHART = 2;
    public static final int VALUE_PLACE_UNDER_CHART = 3;
    public static final int VALUE_SCALE_UNDEF = -1;
    public static final int VALUE_SCALE_FIT = 1;
    public static final int VALUE_SCALE_FIXED = 2;
    public static final int VALUE_SCALE_SCALE = 3;
    public static final int VALUE_SCALE_ABS = 4;
    public static final int HORIZONTAL_LABEL_VERTICAL = 0;
    public static final int HORIZONTAL_LABEL_HORIZONTAL = 1;
    public static final int HORIZONTAL_LABEL_FIT = 1;
    public static final int HORIZONTAL_LABEL_FIXED = 2;
    public static final int HORIZONTAL_LABEL_SCALE = 3;
    public static final int HORIZONTAL_LABEL_ABS = 4;
    public static final int ANIMATE_SEQUENTIAL = 0;
    public static final int ANIMATE_CONSTANT_TIME = 1;
    public static final int ANIMATE_CONSTANT_SPEED = 2;
    public static final float EPSILON = 1.0E-5f;

    public Chart(String string, FlashEnvironment flashEnvironment, Context context, Script script) throws GeneratorApiException {
        this.gContext = context;
        this.gEnv = flashEnvironment;
        this.gClassName = string.concat("Data");
        this.peer = ChartPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            ChartPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            ChartPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setClip(Script script, int n) {
        int n2 = 0;
        if (script != null) {
            n2 = script.getPeer();
        }
        ChartPeer.setClip(this.peer, n2, n);
    }

    public void setLabels(boolean bl) {
        int n = ChartPeer.setLabels(this.peer, bl);
    }

    public void setPieLabelPosition(int n) {
        int n2 = ChartPeer.setPieLabelPosition(this.peer, n);
    }

    public void setBorder(boolean bl) {
        int n = ChartPeer.setBorder(this.peer, bl);
    }

    public void setGridLines(int n) {
        int n2 = ChartPeer.setGridLines(this.peer, n);
    }

    public void setChartDataSize(float f, float f2) throws GeneratorApiException {
        int n = ChartPeer.setChartDataSize(this.peer, f, f2);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart data limits");
        }
    }

    public void setSpacing(int n, int n2) {
        int n3 = ChartPeer.setSpacing(this.peer, n, n2);
    }

    public void setUserLimits(float f, boolean bl, float f2, boolean bl2) throws GeneratorApiException {
        int n = ChartPeer.setUserLimits(this.peer, f, bl, f2, bl2);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart user limits");
        }
    }

    public void setUserXLimits(float f, boolean bl, float f2, boolean bl2) throws GeneratorApiException {
        int n = ChartPeer.setUserXLimits(this.peer, f, bl, f2, bl2);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart user limits");
        }
    }

    public void setDivisions(int n, int n2) throws GeneratorApiException {
        int n3 = ChartPeer.setDivisions(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("Invalid chart divisions");
        }
    }

    public void setOrigin(float f) throws GeneratorApiException {
        int n = ChartPeer.setOrigin(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart origin");
        }
    }

    public void setURL(int n, String string, String string2) throws GeneratorApiException {
        int n2 = ChartPeer.setURL(this.peer, n, string, string2);
        if (n2 == 0) {
            throw new GeneratorApiException("Invalid URL");
        }
    }

    public void setGoTo(int n, int n2, String string) throws GeneratorApiException {
        int n3 = ChartPeer.setGoTo(this.peer, n, n2, string);
        if (n3 == 0) {
            throw new GeneratorApiException("Invalid GoTo");
        }
    }

    public void setGoToLabel(int n, String string, String string2) throws GeneratorApiException {
        int n2 = ChartPeer.setGoToLabel(this.peer, n, string, string2);
        if (n2 == 0) {
            throw new GeneratorApiException("Invalid GoTo");
        }
    }

    public void setStackURL(int n, int n2, String string, String string2) throws GeneratorApiException {
        int n3 = ChartPeer.setStackURL(this.peer, n, n2, string, string2);
        if (n3 == 0) {
            throw new GeneratorApiException("Invalid URL");
        }
    }

    public void setStackGoTo(int n, int n2, int n3, String string) throws GeneratorApiException {
        int n4 = ChartPeer.setStackGoTo(this.peer, n, n2, n3, string);
        if (n4 == 0) {
            throw new GeneratorApiException("Invalid GoTo");
        }
    }

    public void setStackGoToLabel(int n, int n2, String string, String string2) throws GeneratorApiException {
        int n3 = ChartPeer.setStackGoToLabel(this.peer, n, n2, string, string2);
        if (n3 == 0) {
            throw new GeneratorApiException("Invalid GoTo");
        }
    }

    public void setValuePlacement(int n) throws GeneratorApiException {
        int n2 = ChartPeer.setValuePlacement(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("Invalid chart origin");
        }
    }

    public void setValueDisplay(int n, int n2, float f) throws GeneratorApiException {
        if (n != 0 && n != 1 && n != 2) {
            return;
        }
        int n3 = ChartPeer.setValueDisplay(this.peer, n, n2, f);
        if (n3 == 0) {
            throw new GeneratorApiException("Invalid chart origin");
        }
    }

    public void setHorizontalLabelDisplay(int n, int n2, float f) throws GeneratorApiException {
        if (n != 0 && n != 1) {
            return;
        }
        int n3 = ChartPeer.setHorizontalLabelDisplay(this.peer, n, n2, f);
        if (n3 == 0) {
            throw new GeneratorApiException("Invalid horizontal label");
        }
    }

    public void process() throws GeneratorApiException {
        int n = ChartPeer.process(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart");
        }
    }

    public void processLines() throws GeneratorApiException {
        int n = ChartPeer.processLines(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart");
        }
    }

    public void processStock(int n) throws GeneratorApiException {
        int n2 = ChartPeer.processStock(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("Invalid chart");
        }
    }

    public void processPie() throws GeneratorApiException {
        int n = ChartPeer.processPie(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart");
        }
    }

    public void setAutoScale(boolean bl) throws GeneratorApiException {
        int n = ChartPeer.setAutoScale(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart");
        }
    }

    public void setAreaFill(boolean bl) throws GeneratorApiException {
        int n = ChartPeer.setAreaFill(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiException("Invalid chart");
        }
    }

    public void computeChartSize() {
        ChartPeer.computeChartSize(this.peer);
    }

    public float getChartMin() {
        return ChartPeer.getChartMin(this.peer);
    }

    public float getChartMax() {
        return ChartPeer.getChartMax(this.peer);
    }

    public float getMajorInterval() {
        return ChartPeer.getMajorInterval(this.peer);
    }

    public void setLineStyle(int n, int n2, int n3, int n4) {
        ChartPeer.setLineStyle(this.peer, n, n2, n3, n4);
    }

    public void setChartLineThickness(int n) {
        ChartPeer.setChartLineThickness(this.peer, n);
    }

    public void setDataCount(int n) {
        ChartPeer.setDataCount(this.peer, n);
    }

    public void setMultiDimenDataCount(int n, int n2) {
        ChartPeer.setMultiDimenDataCount(this.peer, n, n2);
    }

    public void setStackCount(int n, int n2) {
        ChartPeer.setStackCount(this.peer, n, n2);
    }

    public void setDataValue(int n, float f, int n2) {
        ChartPeer.setDataValue(this.peer, n, f, n2);
    }

    public void setDataValue(int n, float f) {
        ChartPeer.setDataValue(this.peer, n, f);
    }

    public void set2DData(int n, float f, float f2, Script script) {
        int n2 = 0;
        if (script != null) {
            n2 = script.getPeer();
        }
        ChartPeer.set2DData(this.peer, n, f, f2, n2);
    }

    public void setMultiDimenValue(int n, float[] fArray, int n2) {
        ChartPeer.setMultiDimenValue(this.peer, n, fArray, n2);
    }

    public void setDataColor(int n, int n2) {
        ChartPeer.setDataColor(this.peer, n, n2);
    }

    public void setStackValue(int n, int n2, float f) {
        ChartPeer.setStackValue(this.peer, n, n2, f);
    }

    public void setStackColor(int n, int n2) {
        ChartPeer.setStackColor(this.peer, n, n2);
    }

    public void setLabel(float f, Script script) {
        int n = 0;
        if (script != null) {
            n = script.getPeer();
        }
        ChartPeer.setLabel(this.peer, f, n);
    }

    public void addValueScript(int n, Script script) {
        int n2 = 0;
        if (script != null) {
            n2 = script.getPeer();
        }
        ChartPeer.addValueScript(this.peer, n, n2);
    }

    public void addHorizontalLabelScript(int n, Script script) {
        int n2 = 0;
        if (script != null) {
            n2 = script.getPeer();
        }
        ChartPeer.addHorizontalLabelScript(this.peer, n, n2);
    }

    public void addStackValueScript(int n, int n2, Script script) {
        int n3 = 0;
        if (script != null) {
            n3 = script.getPeer();
        }
        ChartPeer.addStackValueScript(this.peer, n, n2, n3);
    }

    public void setFrameCount(int n) {
        ChartPeer.setFrameCount(this.peer, n);
    }

    public void setChartRect(Rect rect) {
        if (rect == null) {
            return;
        }
        ChartPeer.setChartRect(this.peer, rect.getPeer());
    }

    public void setDepth3D(float f) {
        ChartPeer.setDepth3D(this.peer, f);
    }

    public void setEffect3D(boolean bl) {
        ChartPeer.setEffect3D(this.peer, bl);
    }

    public void drawScatterLines(boolean bl) {
        ChartPeer.drawScatterLines(this.peer, bl);
    }

    public void pushDataSet() {
        ChartPeer.pushDataSet(this.peer);
    }

    public void setMaxDataEntries(int n) {
        ChartPeer.setMaxDataEntries(this.peer, n);
    }

    public String MakeFloatLabel(float f) {
        String string;
        int n = (int)f;
        if ((double)(Math.abs(f) - (float)Math.abs(n)) < 0.00999) {
            String string2 = new Integer(n).toString();
            return string2;
        }
        String string3 = f < 0.0f ? new String("-") : new String("");
        n = (int)(Math.abs(f) * 100.0f);
        String string4 = new Integer(n).toString();
        int n2 = string4.length();
        if (n2 < 2) {
            string = new String("0") + string4;
        } else {
            string3 = string3 + string4.substring(0, n2 - 2);
            string = string4.substring(n2 - 2);
        }
        String string5 = string3 + '.' + string;
        return string5;
    }

    public void RenderLabels(FlashEnvironment flashEnvironment, GenVector genVector, Script script) {
        if (script == null) {
            return;
        }
        float f = this.getMajorInterval();
        float f2 = this.getChartMin();
        float f3 = this.getChartMax();
        float f4 = f - (float)new Float(f).longValue();
        boolean bl = f4 < 1.0E-5f;
        float f5 = f2;
        while (f5 <= f3 + 1.0E-5f) {
            Object object;
            Context context = (Context)genVector.add(new Context());
            context.setParent(this.gContext);
            if (bl) {
                object = new Integer((int)f5).toString();
                context.setValue("label", (String)object);
            } else {
                object = this.MakeFloatLabel(f5);
                context.setValue("label", (String)object);
            }
            object = (Script)genVector.add(script.copyScript());
            flashEnvironment.processScript((Script)object, context);
            this.setLabel(f5, (Script)object);
            f5 += f;
            genVector.release(context);
            genVector.release((GenObject)object);
        }
    }

    public Script getSymbolScript(String string) {
        File file = null;
        Script script = null;
        if (string != null && string != "") {
            Object object;
            Mac mac = Mac.getMac();
            if (mac != null) {
                object = mac.makeJavaPretty(string);
                file = new File((String)object);
                if (!file.exists() || !file.isFile()) {
                    file = new File(((String)object).substring(1));
                }
            } else {
                file = new File(string);
            }
            if (!file.isAbsolute()) {
                file = new File(this.gEnv.getDirectory(), file.getPath());
            }
            if (!file.exists() || !file.isFile()) {
                script = null;
            } else {
                script = new Script();
                boolean bl = this.gEnv.getPreviewMode();
                try {
                    script.setFile(file.getPath(), !bl);
                }
                catch (GeneratorApiException generatorApiException) {
                    script = null;
                }
            }
            if (script != null) {
                try {
                    object = this.gEnv.getCacheManager();
                    if (object != null) {
                        ((CacheManager)object).loadExternalFonts(this.gEnv, script);
                    }
                }
                catch (GeneratorApiException generatorApiException) {
                    // empty catch block
                }
            }
        }
        if (script == null) {
            this.gEnv.loadDefaultSymbols();
            script = this.gEnv.getDefaultSymbolScript();
        }
        return script;
    }

    public Script getValueScript(Script script, PropertyParser propertyParser) {
        Script script2;
        if (script == null || propertyParser == null) {
            return null;
        }
        String string = "chartValue1";
        String string2 = propertyParser.GetStringParam("valueformat");
        if (string2 != null) {
            if (string2.equalsIgnoreCase(this.GetResourceString("Arial"))) {
                string = "chartValue1";
            } else if (string2.equalsIgnoreCase(this.GetResourceString("Times"))) {
                string = "chartValue2";
            } else if (string2.equalsIgnoreCase(this.GetResourceString("Courier"))) {
                string = "chartValue3";
            }
        }
        if ((script2 = script.findScript(string)) == null && (script2 = script.findScript("chartValue1")) == null && (script2 = script.findScript("chartValue2")) == null) {
            script2 = script.findScript("chartValue3");
        }
        return script2;
    }

    public Script getLabelScript(Script script, PropertyParser propertyParser) {
        Script script2;
        if (script == null || propertyParser == null) {
            return null;
        }
        String string = "chartLabel1";
        String string2 = propertyParser.GetStringParam("labelformat");
        if (string2 != null) {
            if (string2.equalsIgnoreCase(this.GetResourceString("Arial"))) {
                string = "chartLabel1";
            } else if (string2.equalsIgnoreCase(this.GetResourceString("Times"))) {
                string = "chartLabel2";
            } else if (string2.equalsIgnoreCase(this.GetResourceString("Courier"))) {
                string = "chartLabel3";
            }
        }
        if ((script2 = script.findScript(string)) == null && (script2 = script.findScript("chartLabel1")) == null && (script2 = script.findScript("chartLabel2")) == null) {
            script2 = script.findScript("chartLabel3");
        }
        return script2;
    }

    public Script getScatterValueScript(Script script, PropertyParser propertyParser) {
        if (script == null || propertyParser == null) {
            return null;
        }
        String string = "scatterValue1";
        String string2 = propertyParser.GetStringParam("valueformat");
        if (string2 != null) {
            if (string2.equalsIgnoreCase(this.GetResourceString("Arial"))) {
                string = "scatterValue1";
            } else if (string2.equalsIgnoreCase(this.GetResourceString("Times"))) {
                string = "scatterValue2";
            } else if (string2.equalsIgnoreCase(this.GetResourceString("Courier"))) {
                string = "scatterValue3";
            }
        }
        Script script2 = script.findScript(string);
        return script2;
    }

    public String GetResourceString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.gClassName, Locale.getDefault());
        return resourceBundle.getString(string);
    }
}

