/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.GifBuilder;
import com.macromedia.generator.api.JPEGBuilder;
import com.macromedia.generator.api.PngBuilder;
import com.macromedia.generator.api.ProjectorBuilder;
import com.macromedia.generator.api.Serial;
import com.macromedia.generator.api.TextBuilder;
import com.macromedia.generator.app.CacheManager;
import com.macromedia.generator.app.CacheProperties;
import com.macromedia.generator.app.FlashCommandLog;
import com.macromedia.generator.app.FlashEnvironment;
import com.macromedia.generator.platform.Mac;
import com.macromedia.generator.platform.Unix;
import com.macromedia.generator.utils.GenUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class FlashGeneratorApp
implements FlashCommandLog {
    protected int logLevel = 1;
    protected String extFontLocation = null;
    protected boolean logOpened = false;
    protected String logPath;
    protected String inputPath;
    protected String gifPath;
    protected String jpegPath;
    protected String pngPath;
    protected String QTMPath;
    protected String txtPath;
    protected String flashPath;
    protected String projectorWPath;
    protected String projectorMPPCPath;
    protected String projectorM68kPath;
    protected String projectorMFatPath;
    protected String projectorW16Path;
    protected String serverMapPath;
    protected String clientMapPath;
    protected String clientMapName;
    protected String embeddedString;
    protected Vector params;
    protected PrintWriter logWriter;
    protected boolean isPreviewMode = false;
    protected int projectorType = 0;
    protected int defaultWidth = -1;
    protected int defaultHeight = -1;
    protected int defaultBitDepth = 0;
    protected boolean exactFit = false;
    protected String bgColor;
    protected ResourceBundle resources;
    protected Serial serial = null;
    protected boolean publishSerialNum = true;
    protected CacheManager cacheMgr = null;
    protected CacheProperties cacheProps = null;

    protected void finalize() throws Throwable {
        if (this.logWriter != null) {
            this.logWriter.flush();
            this.logWriter.close();
            this.logWriter = null;
        }
        if (this.cacheMgr != null) {
            this.cacheMgr = null;
        }
    }

    protected void resetPaths() {
        this.logPath = null;
        this.inputPath = null;
        this.gifPath = null;
        this.jpegPath = null;
        this.pngPath = null;
        this.QTMPath = null;
        this.txtPath = null;
        this.flashPath = null;
        this.projectorWPath = null;
        this.projectorMPPCPath = null;
        this.projectorM68kPath = null;
        this.projectorMFatPath = null;
        this.projectorW16Path = null;
        this.serverMapPath = null;
        this.clientMapPath = null;
        this.clientMapName = null;
    }

    protected void loadResources() {
        if (this.resources == null) {
            this.resources = ResourceBundle.getBundle("com.macromedia.generator.resources.ResourceData", Locale.getDefault());
        }
    }

    protected String getPropertiesPath() {
        String string = System.getProperty("com.macromedia.generator.installpath");
        String string2 = System.getProperty("file.separator");
        return string + string2 + "properties" + string2 + "generator.properties";
    }

    protected String getSerializePath() {
        String string = System.getProperty("com.macromedia.generator.installpath");
        String string2 = System.getProperty("file.separator");
        return string + string2 + ".serialize";
    }

    protected void initProperties() {
        Object object;
        Object object2;
        Object object3;
        Properties properties = new Properties();
        try {
            object3 = new FileInputStream(this.getPropertiesPath());
            properties.load((InputStream)object3);
            ((FileInputStream)object3).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cacheProps = new CacheProperties();
        object3 = System.getProperties();
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        Object var4_5 = null;
        Object var5_6 = null;
        if (Mac.getMac() != null) {
            object2 = System.getProperty("user.dir");
            object2 = (String)object2 + System.getProperty("file.separator") + "Generator";
            object = System.getProperties();
            ((Hashtable)object).put("com.macromedia.generator.installpath", object2);
            System.setProperties((Properties)object);
        }
        object2 = ((Hashtable)properties).keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            String string = (String)((Hashtable)properties).get(object);
            string = string.trim();
            if (((String)object).equalsIgnoreCase("com.macromedia.generator.userclasspath")) {
                ((Hashtable)object3).put("java.class.path", (String)((Hashtable)object3).get("java.class.path") + ((Hashtable)object3).get("path.separator") + ((Hashtable)properties).get(object));
                continue;
            }
            if (((String)object).equalsIgnoreCase("com.macromedia.generator.qastud")) {
                if (!string.equalsIgnoreCase("beauchamp")) continue;
                this.publishSerialNum = false;
                if (this.serial == null) continue;
                this.serial.setPublished(false);
                continue;
            }
            ((Hashtable)object3).put(object, (String)((Hashtable)properties).get(object));
        }
        this.embeddedString = null;
        this.bgColor = null;
    }

    protected boolean setCacheProperty(String string, String string2) {
        if (this.cacheProps != null) {
            return this.cacheProps.set(string, string2);
        }
        return false;
    }

    protected void initSerialization() {
        if (this.serial == null) {
            this.serial = new Serial();
            Unix unix = Unix.getUnix();
            if (unix != null) {
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(this.getSerializePath());
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.serial.setFirstName((String)((Hashtable)properties).get("FirstName"));
                this.serial.setMiddleName((String)((Hashtable)properties).get("MiddleName"));
                this.serial.setLastName((String)((Hashtable)properties).get("LastName"));
                this.serial.setOrganization((String)((Hashtable)properties).get("Organization"));
                this.serial.setServerNumber((String)((Hashtable)properties).get("ServerNumber"));
            }
        }
        this.serial.setPublished(this.publishSerialNum);
    }

    protected void initCaches() {
        this.cacheMgr = this.cacheProps != null ? new CacheManager(this.cacheProps) : new CacheManager();
    }

    protected void setMacFileType(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return;
        }
        Mac mac = Mac.getMac();
        if (mac == null) {
            return;
        }
        File file = new File(string);
        if (file == null) {
            return;
        }
        if (file.exists()) {
            mac.setTypeAndCreator(file, string2, string3);
        }
    }

    protected String addExtension(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        Mac mac = Mac.getMac();
        if (mac == null) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string;
        }
        if (!string2.startsWith(".") && !string.endsWith(".")) {
            string2 = "." + string2;
        }
        return string + string2;
    }

    protected void writeBuffer(String string, Buffer buffer) {
        try {
            if (string != null) {
                if (!string.equals("-")) {
                    File file = new File(string);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    int n = buffer.getBufferCount();
                    int n2 = 0;
                    while (n2 < n) {
                        byte[] byArray = buffer.getBuffer(n2);
                        fileOutputStream.write(byArray);
                        ++n2;
                    }
                    fileOutputStream.close();
                } else {
                    int n = buffer.getBufferCount();
                    int n3 = 0;
                    while (n3 < n) {
                        byte[] byArray = buffer.getBuffer(n3);
                        ((FilterOutputStream)System.out).write(byArray);
                        ++n3;
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log(this.getResString("OutputFileInvalid") + string);
        }
        catch (IOException iOException) {
            this.log(this.getResString("OutputFileError") + string);
        }
        catch (GeneratorApiException generatorApiException) {
            this.log(this.getResString("OutputFileError") + string);
        }
    }

    protected void deleteFile(String string) {
        File file;
        if (string != null && !string.equals("-") && (file = new File(string)).isFile()) {
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processArgs(String[] stringArray) {
        Mac mac = Mac.getMac();
        this.params = new Vector();
        if (stringArray.length < 1) {
            this.usage(true);
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            block89: {
                String string;
                block108: {
                    block107: {
                        block106: {
                            block105: {
                                block104: {
                                    block103: {
                                        block102: {
                                            block101: {
                                                block100: {
                                                    block99: {
                                                        block98: {
                                                            block97: {
                                                                block96: {
                                                                    block95: {
                                                                        block94: {
                                                                            block93: {
                                                                                block92: {
                                                                                    block91: {
                                                                                        block90: {
                                                                                            string = stringArray[n].toLowerCase();
                                                                                            if (string.equals("-h")) {
                                                                                                this.log(this.getResString("DashHObsolete"));
                                                                                                string = "-help";
                                                                                            } else if (string.equals("-d")) {
                                                                                                this.log(this.getResString("DashDObsolete"));
                                                                                                string = "-debug";
                                                                                            } else if (string.equals("-f")) {
                                                                                                this.log(this.getResString("DashFObsolete"));
                                                                                                string = "-swf";
                                                                                            } else if (string.equals("-s")) {
                                                                                                this.log(this.getResString("DashSObsolete"));
                                                                                                string = "-smap";
                                                                                            } else if (string.equals("-c")) {
                                                                                                this.log(this.getResString("DashCObsolete"));
                                                                                                string = "-cmap";
                                                                                            } else if (string.equals("-n")) {
                                                                                                this.log(this.getResString("DashNObsolete"));
                                                                                                string = "-cmapname";
                                                                                            } else if (string.equals("-g")) {
                                                                                                this.log(this.getResString("DashGObsolete"));
                                                                                                string = "-gif";
                                                                                            } else if (string.equals("-l")) {
                                                                                                this.log(this.getResString("DashLObsolete"));
                                                                                                string = "-log";
                                                                                            } else if (string.equals("-p")) {
                                                                                                this.log(this.getResString("DashPObsolete"));
                                                                                                string = "-param";
                                                                                            }
                                                                                            if (string.equals("-help")) {
                                                                                                this.usage(true);
                                                                                                return false;
                                                                                            }
                                                                                            if (!string.equals("-swf")) break block90;
                                                                                            if (n + 1 >= stringArray.length) {
                                                                                                this.log(this.getResString("DashSwfRequiresArg"));
                                                                                                this.usage(false);
                                                                                                return false;
                                                                                            }
                                                                                            this.flashPath = stringArray[++n];
                                                                                            if (mac != null) {
                                                                                                this.flashPath = mac.makeJavaPretty(this.flashPath);
                                                                                            }
                                                                                            break block89;
                                                                                        }
                                                                                        if (!string.equals("-gif")) break block91;
                                                                                        if (n + 1 >= stringArray.length) {
                                                                                            this.log(this.getResString("DashGifRequiresArg"));
                                                                                            this.usage(false);
                                                                                            return false;
                                                                                        }
                                                                                        this.gifPath = stringArray[++n];
                                                                                        if (mac != null) {
                                                                                            this.gifPath = mac.makeJavaPretty(this.gifPath);
                                                                                        }
                                                                                        break block89;
                                                                                    }
                                                                                    if (!string.equals("-txt")) break block92;
                                                                                    if (n + 1 >= stringArray.length) {
                                                                                        this.log(this.getResString("DashTxtRequiresArg"));
                                                                                        this.usage(false);
                                                                                        return false;
                                                                                    }
                                                                                    this.txtPath = stringArray[++n];
                                                                                    if (mac != null) {
                                                                                        this.txtPath = mac.makeJavaPretty(this.txtPath);
                                                                                    }
                                                                                    break block89;
                                                                                }
                                                                                if (!string.equals("-jpg")) break block93;
                                                                                if (n + 1 >= stringArray.length) {
                                                                                    this.log(this.getResString("DashJpgRequiresArg"));
                                                                                    this.usage(false);
                                                                                    return false;
                                                                                }
                                                                                this.jpegPath = stringArray[++n];
                                                                                if (mac != null) {
                                                                                    this.jpegPath = mac.makeJavaPretty(this.jpegPath);
                                                                                }
                                                                                break block89;
                                                                            }
                                                                            if (!string.equals("-png")) break block94;
                                                                            if (n + 1 >= stringArray.length) {
                                                                                this.log(this.getResString("DashPngRequiresArg"));
                                                                                this.usage(false);
                                                                                return false;
                                                                            }
                                                                            this.pngPath = stringArray[++n];
                                                                            if (mac != null) {
                                                                                this.pngPath = mac.makeJavaPretty(this.pngPath);
                                                                            }
                                                                            break block89;
                                                                        }
                                                                        if (!string.equals("-qtm")) break block95;
                                                                        if (n + 1 >= stringArray.length) {
                                                                            this.log(this.getResString("DashQTMRequiresArg"));
                                                                            this.usage(false);
                                                                            return false;
                                                                        }
                                                                        this.QTMPath = stringArray[++n];
                                                                        if (mac != null) {
                                                                            this.QTMPath = mac.makeJavaPretty(this.QTMPath);
                                                                        }
                                                                        break block89;
                                                                    }
                                                                    if (!string.equals("-xwin32")) break block96;
                                                                    if (n + 1 >= stringArray.length) {
                                                                        this.log(this.getResString("DashWin32RequiresArg"));
                                                                        this.usage(false);
                                                                        return false;
                                                                    }
                                                                    this.projectorWPath = stringArray[++n];
                                                                    break block89;
                                                                }
                                                                if (!string.equals("-xwin16")) break block97;
                                                                if (n + 1 >= stringArray.length) {
                                                                    this.log(this.getResString("DashWin16RequiresArg"));
                                                                    this.usage(false);
                                                                    return false;
                                                                }
                                                                this.projectorW16Path = stringArray[++n];
                                                                break block89;
                                                            }
                                                            if (!string.equals("-xmacfat")) break block98;
                                                            if (n + 1 >= stringArray.length) {
                                                                this.log(this.getResString("DashMacFatRequiresArg"));
                                                                this.usage(false);
                                                                return false;
                                                            }
                                                            this.projectorMFatPath = stringArray[++n];
                                                            break block89;
                                                        }
                                                        if (!string.equals("-xmacppc")) break block99;
                                                        if (n + 1 >= stringArray.length) {
                                                            this.log(this.getResString("DashWinPpcRequiresArg"));
                                                            this.usage(false);
                                                            return false;
                                                        }
                                                        this.projectorMPPCPath = stringArray[++n];
                                                        break block89;
                                                    }
                                                    if (!string.equals("-xmac68k")) break block100;
                                                    if (n + 1 >= stringArray.length) {
                                                        this.log(this.getResString("DashMac68KRequiresArg"));
                                                        this.usage(false);
                                                        return false;
                                                    }
                                                    this.projectorM68kPath = stringArray[++n];
                                                    break block89;
                                                }
                                                if (!string.equals("-smap")) break block101;
                                                if (n + 1 >= stringArray.length) {
                                                    this.log(this.getResString("DashSmapRequiresArg"));
                                                    this.usage(false);
                                                    return false;
                                                }
                                                this.serverMapPath = stringArray[++n];
                                                break block89;
                                            }
                                            if (!string.equals("-cmap")) break block102;
                                            if (n + 1 >= stringArray.length) {
                                                this.log(this.getResString("DashCmapRequiresArg"));
                                                this.usage(false);
                                                return false;
                                            }
                                            this.clientMapPath = stringArray[++n];
                                            if (this.clientMapName == null) {
                                                this.clientMapName = new String("NOMAPNAME");
                                            }
                                            break block89;
                                        }
                                        if (!string.equals("-cmapname")) break block103;
                                        if (n + 1 >= stringArray.length) {
                                            this.log(this.getResString("DashCmapnameRequiresArg"));
                                            this.usage(false);
                                            return false;
                                        }
                                        this.clientMapName = stringArray[++n];
                                        break block89;
                                    }
                                    if (!string.equals("-log")) break block104;
                                    if (n + 1 >= stringArray.length) {
                                        this.log(this.getResString("DashLogRequiresArg"));
                                        this.usage(false);
                                        return false;
                                    }
                                    this.logPath = stringArray[++n];
                                    if (mac != null) {
                                        this.logPath = mac.makeJavaPretty(this.logPath);
                                    }
                                    try {
                                        File file = new File(this.logPath);
                                        this.logWriter = new PrintWriter(new FileOutputStream(file));
                                        if (mac != null) {
                                            mac.setTypeAndCreator(file, "TEXT", "ttxt");
                                        }
                                    }
                                    catch (Exception exception) {
                                        System.err.println(this.getResString("LogFileInvalid") + this.logPath);
                                    }
                                    this.logOpened = true;
                                    break block89;
                                }
                                if (!string.equals("-debug")) break block105;
                                if (n + 1 >= stringArray.length) {
                                    this.log(this.getResString("DashDebugRequiresArg"));
                                    this.usage(false);
                                    return false;
                                }
                                try {
                                    this.logLevel = Integer.valueOf(stringArray[++n]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.logLevel = -1;
                                }
                                if (this.logLevel < 0 || this.logLevel > 3) {
                                    this.log(this.getResString("InvalidDashDebugArg"));
                                    this.usage(false);
                                    return false;
                                }
                                break block89;
                            }
                            if (!string.equals("-font")) break block106;
                            if (n + 1 < stringArray.length) {
                                this.extFontLocation = stringArray[++n];
                                if (mac != null) {
                                    this.extFontLocation = mac.makeJavaPretty(this.extFontLocation);
                                }
                            }
                            break block89;
                        }
                        if (!string.equals("-param")) break block107;
                        if (n + 2 >= stringArray.length) {
                            this.log(this.getResString("DashParamRequiresArg"));
                            this.usage(false);
                            return false;
                        }
                        String[] stringArray2 = new String[]{stringArray[n + 1], stringArray[n + 2]};
                        stringArray2[1] = GenUtils.replace(stringArray2[1], "\\r", '\r');
                        stringArray2[1] = GenUtils.replace(stringArray2[1], "\\n", '\n');
                        this.params.addElement(stringArray2);
                        n += 2;
                        break block89;
                    }
                    if (!string.equals("-t")) break block108;
                    if (n + 1 < stringArray.length) {
                        if (this.inputPath != null) {
                            this.log(this.getResString("MultipleInputFiles") + stringArray[n]);
                            this.usage(false);
                            return false;
                        }
                        this.inputPath = stringArray[++n];
                        if (mac != null) {
                            this.inputPath = mac.makeJavaPretty(this.inputPath);
                        }
                    }
                    break block89;
                }
                if (string.equals("-embed")) {
                    if (n + 1 >= stringArray.length) {
                        this.log(this.getResString("DashEmbedRequiresArg"));
                        this.usage(false);
                        return false;
                    }
                    this.embeddedString = stringArray[++n];
                } else if (string.equalsIgnoreCase("-defaultsize")) {
                    if (n + 2 >= stringArray.length) {
                        this.log(this.getResString("DashDefaultSizeRequiresArg"));
                        this.usage(false);
                        return false;
                    }
                    try {
                        this.defaultWidth = Integer.valueOf(stringArray[++n]);
                        this.defaultHeight = Integer.valueOf(stringArray[++n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.defaultWidth = -1;
                        this.defaultHeight = -1;
                    }
                    if (this.defaultWidth <= 0 || this.defaultHeight <= 0) {
                        this.log(this.getResString("DashDefaultSizeInvalidArg"));
                        this.usage(false);
                        return false;
                    }
                } else {
                    if (string.equalsIgnoreCase("-pngBitDepth")) {
                        if (n + 1 >= stringArray.length) {
                            this.log(this.getResString("DashBitDepthRequiresArg"));
                            this.usage(false);
                            return false;
                        }
                        int n2 = -1;
                        try {
                            int n3 = Integer.valueOf(stringArray[++n]);
                            switch (n3) {
                                case 8: {
                                    n2 = 0;
                                    break;
                                }
                                case 24: {
                                    n2 = 1;
                                    break;
                                }
                                case 32: {
                                    n2 = 2;
                                    break;
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = -1;
                        }
                        if (n2 >= 0 && n2 <= 2) {
                            this.defaultBitDepth = n2;
                            break block89;
                        } else {
                            this.log(this.getResString("DashBitDepthInvalidArg"));
                            this.usage(false);
                            return false;
                        }
                    }
                    if (string.equalsIgnoreCase("-exactFit")) {
                        this.exactFit = true;
                    } else if (string.equalsIgnoreCase("-bgColor")) {
                        if (n + 1 >= stringArray.length) {
                            this.log(this.getResString("DashBGColorRequiresArg"));
                            this.usage(false);
                            return false;
                        }
                        this.bgColor = stringArray[++n];
                        if (this.bgColor.charAt(0) == '#' && this.bgColor.length() != 7) {
                            this.log(this.getResString("DashBGColorInvalidHex") + this.bgColor);
                            this.usage(false);
                            return false;
                        }
                        try {
                            new Color().setRGBValue(this.bgColor);
                        }
                        catch (GeneratorApiException generatorApiException) {
                            this.log(this.getResString("DashBGColorInvalidColor") + this.bgColor);
                            this.usage(false);
                            return false;
                        }
                    } else {
                        if (!string.endsWith(".swf") && !string.endsWith(".swt")) {
                            this.log(this.getResString("InvalidFlag") + stringArray[n]);
                            this.usage(false);
                            return false;
                        }
                        if (this.inputPath != null) {
                            this.log(this.getResString("MultipleInputFiles") + stringArray[n]);
                            this.usage(false);
                            return false;
                        }
                        this.inputPath = stringArray[n];
                        if (mac != null) {
                            this.inputPath = mac.makeJavaPretty(this.inputPath);
                        }
                    }
                }
            }
            ++n;
        }
        if (this.inputPath == null) {
            this.usage(false);
            return false;
        }
        if (this.flashPath == null && this.gifPath == null && this.jpegPath == null && this.pngPath == null && this.QTMPath == null && this.serverMapPath == null && this.clientMapPath == null && this.projectorWPath == null && this.projectorMPPCPath == null && this.projectorMFatPath == null && this.projectorM68kPath == null && this.projectorW16Path == null && this.txtPath == null) {
            this.log(this.getResString("NothingToDo"));
            this.usage(false);
            return false;
        }
        return true;
    }

    protected boolean processTemplate() {
        if (this.gifPath != null) {
            this.deleteFile(this.gifPath);
        }
        if (this.jpegPath != null) {
            this.deleteFile(this.jpegPath);
        }
        if (this.pngPath != null) {
            this.deleteFile(this.pngPath);
        }
        if (this.QTMPath != null) {
            this.deleteFile(this.QTMPath);
        }
        if (this.txtPath != null) {
            this.deleteFile(this.txtPath);
        }
        if (this.flashPath != null) {
            this.deleteFile(this.flashPath);
        }
        if (this.projectorWPath != null) {
            this.deleteFile(this.projectorWPath);
        }
        if (this.projectorMPPCPath != null) {
            this.deleteFile(this.projectorMPPCPath);
        }
        if (this.projectorMFatPath != null) {
            this.deleteFile(this.projectorMFatPath);
        }
        if (this.projectorM68kPath != null) {
            this.deleteFile(this.projectorM68kPath);
        }
        if (this.projectorW16Path != null) {
            this.deleteFile(this.projectorW16Path);
        }
        if (this.serverMapPath != null) {
            this.deleteFile(this.serverMapPath);
        }
        if (this.clientMapPath != null) {
            this.deleteFile(this.clientMapPath);
        }
        FlashEnvironment flashEnvironment = new FlashEnvironment(this.logLevel, this.isPreviewMode, this.serial, this.extFontLocation, this.cacheMgr);
        flashEnvironment.setEmbeddedString(this.embeddedString);
        flashEnvironment.setBackgroundColor(this.bgColor);
        try {
            String string;
            Buffer buffer = flashEnvironment.processTemplate(new File(this.inputPath), this.params);
            if (buffer != null) {
                Object object;
                Object object2;
                GenObject genObject;
                Object object3;
                Boolean bl;
                Boolean bl2;
                int n = this.defaultWidth;
                int n2 = this.defaultHeight;
                int n3 = 0;
                int n4 = 2;
                int n5 = 0;
                int n6 = -1;
                int n7 = 128;
                boolean bl3 = true;
                boolean bl4 = false;
                boolean bl5 = true;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = true;
                boolean bl11 = false;
                String string2 = "";
                int n8 = this.defaultWidth;
                int n9 = this.defaultHeight;
                int n10 = 70;
                boolean bl12 = true;
                int n11 = this.defaultBitDepth;
                int n12 = this.defaultWidth;
                int n13 = this.defaultHeight;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                int n17 = 64;
                boolean bl13 = true;
                boolean bl14 = true;
                boolean bl15 = true;
                boolean bl16 = false;
                boolean bl17 = true;
                String string3 = "";
                Boolean bl18 = (Boolean)flashEnvironment.get("GifInitialized");
                if (bl18 != null && bl18.booleanValue()) {
                    n = (Integer)flashEnvironment.get("GifWidth");
                    n2 = (Integer)flashEnvironment.get("GifHeight");
                    n3 = (Integer)flashEnvironment.get("GifLoopCount");
                    bl3 = (Boolean)flashEnvironment.get("GifAnimated");
                    bl4 = (Boolean)flashEnvironment.get("GifDither");
                    n4 = (Integer)flashEnvironment.get("GifDitherType");
                    bl5 = (Boolean)flashEnvironment.get("GifSmooth");
                    bl6 = (Boolean)flashEnvironment.get("GifInterlace");
                    bl7 = (Boolean)flashEnvironment.get("GifTransparent");
                    bl8 = (Boolean)flashEnvironment.get("GifTransparentSmart");
                    n7 = (Integer)flashEnvironment.get("GifTransparentThreshold");
                    bl9 = (Boolean)flashEnvironment.get("GifNoGradients");
                    bl10 = (Boolean)flashEnvironment.get("GifColorOpt");
                    n5 = (Integer)flashEnvironment.get("GifPaletteType");
                    n6 = (Integer)flashEnvironment.get("GifMaxColors");
                    bl11 = (Boolean)flashEnvironment.get("GifQuality");
                    string2 = (String)flashEnvironment.get("GifPaletteFile");
                }
                if ((bl2 = (Boolean)flashEnvironment.get("JPEGInitialized")) != null && bl2.booleanValue()) {
                    n8 = (Integer)flashEnvironment.get("JPEGWidth");
                    n9 = (Integer)flashEnvironment.get("JPEGHeight");
                    n10 = (Integer)flashEnvironment.get("JPEGQuality");
                    bl12 = (Boolean)flashEnvironment.get("JPEGProgressive");
                }
                if ((bl = (Boolean)flashEnvironment.get("PNGInitialized")) != null && bl.booleanValue()) {
                    n11 = (Integer)flashEnvironment.get("PNGType");
                    n12 = (Integer)flashEnvironment.get("PNGWidth");
                    n13 = (Integer)flashEnvironment.get("PNGHeight");
                    n14 = (Integer)flashEnvironment.get("PNGOption");
                    n15 = (Integer)flashEnvironment.get("PNGDitherType");
                    bl13 = (Boolean)flashEnvironment.get("PNGInterlace");
                    bl14 = (Boolean)flashEnvironment.get("PNGSmooth");
                    bl15 = (Boolean)flashEnvironment.get("PNGDither");
                    bl16 = (Boolean)flashEnvironment.get("PNGNoGradients");
                    bl17 = (Boolean)flashEnvironment.get("PNGColorOpt");
                    n16 = (Integer)flashEnvironment.get("PNGPaletteType");
                    n17 = (Integer)flashEnvironment.get("PNGMaxColors");
                    string3 = (String)flashEnvironment.get("PNGPaletteFile");
                }
                if (this.flashPath != null) {
                    this.writeBuffer(this.flashPath, buffer);
                    this.setMacFileType(this.flashPath, "SWFL", "SWF2");
                }
                if (this.projectorWPath != null) {
                    object3 = System.getProperty("com.macromedia.generator.installpath");
                    genObject = new ProjectorBuilder();
                    object2 = new Buffer();
                    object = System.getProperty("file.separator");
                    ((ProjectorBuilder)genObject).setPlayerFile((String)object3 + (String)object + "bin" + (String)object + "FlashPla.exe");
                    ((ProjectorBuilder)genObject).setOS(0);
                    ((ProjectorBuilder)genObject).build(buffer, (Buffer)object2);
                    this.writeBuffer(this.projectorWPath, (Buffer)object2);
                    ((Buffer)object2).release();
                    ((ProjectorBuilder)genObject).release();
                    this.setMacFileType(this.projectorWPath, "TEXT", "LMAN");
                }
                if (this.projectorMPPCPath != null) {
                    object3 = System.getProperty("com.macromedia.generator.installpath");
                    genObject = new ProjectorBuilder();
                    object2 = new Buffer();
                    object = System.getProperty("file.separator");
                    ((ProjectorBuilder)genObject).setPlayerFile((String)object3 + (String)object + "bin" + (String)object);
                    ((ProjectorBuilder)genObject).setOS(1);
                    ((ProjectorBuilder)genObject).build(buffer, (Buffer)object2);
                    this.projectorMPPCPath = this.addExtension(this.projectorMPPCPath, ".hqx");
                    this.writeBuffer(this.projectorMPPCPath, (Buffer)object2);
                    ((Buffer)object2).release();
                    this.setMacFileType(this.projectorMPPCPath, "TEXT", "SITx");
                }
                if (this.projectorMFatPath != null) {
                    object3 = System.getProperty("com.macromedia.generator.installpath");
                    genObject = new ProjectorBuilder();
                    object2 = new Buffer();
                    object = System.getProperty("file.separator");
                    ((ProjectorBuilder)genObject).setPlayerFile((String)object3 + (String)object + "bin" + (String)object);
                    ((ProjectorBuilder)genObject).setOS(2);
                    ((ProjectorBuilder)genObject).build(buffer, (Buffer)object2);
                    this.projectorMFatPath = this.addExtension(this.projectorMFatPath, ".hqx");
                    this.writeBuffer(this.projectorMFatPath, (Buffer)object2);
                    ((Buffer)object2).release();
                    this.setMacFileType(this.projectorMFatPath, "TEXT", "SITx");
                }
                if (this.projectorM68kPath != null) {
                    object3 = System.getProperty("com.macromedia.generator.installpath");
                    genObject = new ProjectorBuilder();
                    object2 = new Buffer();
                    object = System.getProperty("file.separator");
                    ((ProjectorBuilder)genObject).setPlayerFile((String)object3 + (String)object + "bin" + (String)object);
                    ((ProjectorBuilder)genObject).setOS(3);
                    ((ProjectorBuilder)genObject).build(buffer, (Buffer)object2);
                    this.projectorM68kPath = this.addExtension(this.projectorM68kPath, ".hqx");
                    this.writeBuffer(this.projectorM68kPath, (Buffer)object2);
                    ((Buffer)object2).release();
                    this.setMacFileType(this.projectorM68kPath, "TEXT", "SITx");
                }
                if (this.projectorW16Path != null) {
                    object3 = System.getProperty("com.macromedia.generator.installpath");
                    genObject = new ProjectorBuilder();
                    object2 = new Buffer();
                    object = System.getProperty("file.separator");
                    ((ProjectorBuilder)genObject).setPlayerFile((String)object3 + (String)object + "bin" + (String)object + "FlashPla.exe");
                    ((ProjectorBuilder)genObject).setOS(0);
                    ((ProjectorBuilder)genObject).build(buffer, (Buffer)object2);
                    this.writeBuffer(this.projectorW16Path, (Buffer)object2);
                    ((Buffer)object2).release();
                    ((ProjectorBuilder)genObject).release();
                    this.setMacFileType(this.projectorW16Path, "TEXT", "LMAN");
                }
                if (this.txtPath != null) {
                    object3 = new TextBuilder();
                    genObject = new Buffer();
                    ((TextBuilder)object3).build(buffer, (Buffer)genObject);
                    this.writeBuffer(this.txtPath, (Buffer)genObject);
                    ((Buffer)genObject).release();
                    this.setMacFileType(this.txtPath, "TEXT", "ttxt");
                }
                if (this.gifPath != null) {
                    object3 = new GifBuilder();
                    ((GifBuilder)object3).setSerial(this.serial);
                    genObject = new Buffer();
                    ((GifBuilder)object3).setDither(bl4);
                    ((GifBuilder)object3).setSmooth(bl5);
                    ((GifBuilder)object3).setInterlace(bl6);
                    ((GifBuilder)object3).setTransparent(bl7);
                    ((GifBuilder)object3).setTransparentSmart(bl8);
                    ((GifBuilder)object3).setTransparentThreshold(n7);
                    ((GifBuilder)object3).setGradient(bl9);
                    ((GifBuilder)object3).setLoopCount(n3);
                    ((GifBuilder)object3).setDitherType(n4);
                    ((GifBuilder)object3).setColorOptimization(bl10);
                    ((GifBuilder)object3).setPaletteType(n5);
                    ((GifBuilder)object3).setQuality(bl11);
                    ((GifBuilder)object3).setMaxColors(n6);
                    ((GifBuilder)object3).setAnimated(bl3);
                    object2 = Mac.getMac();
                    if (object2 != null) {
                        string2 = ((Mac)object2).makeSystemPretty(string2);
                    }
                    ((GifBuilder)object3).setFilePalette(string2);
                    if (n > 0 && n2 > 0) {
                        ((GifBuilder)object3).setDimensions(n, n2);
                    }
                    ((GifBuilder)object3).setExactFit(this.exactFit);
                    if (this.bgColor != null) {
                        ((GifBuilder)object3).setBackgroundColor(this.bgColor);
                    }
                    ((GifBuilder)object3).build(buffer, (Buffer)genObject);
                    this.writeBuffer(this.gifPath, (Buffer)genObject);
                    ((Buffer)genObject).release();
                    ((GifBuilder)object3).release();
                    this.setMacFileType(this.gifPath, "GIFf", "MFL2");
                }
                if (this.jpegPath != null) {
                    object3 = new JPEGBuilder();
                    ((JPEGBuilder)object3).setSerial(this.serial);
                    genObject = new Buffer();
                    if (n8 > 0 || n9 > 0) {
                        ((JPEGBuilder)object3).setDimensions(n8, n9);
                    }
                    ((JPEGBuilder)object3).setQuality(n10);
                    ((JPEGBuilder)object3).setProgressive(bl12);
                    ((JPEGBuilder)object3).setExactFit(this.exactFit);
                    if (this.bgColor != null) {
                        ((JPEGBuilder)object3).setBackgroundColor(this.bgColor);
                    }
                    object2 = Mac.getMac();
                    ((JPEGBuilder)object3).build(buffer, (Buffer)genObject);
                    this.writeBuffer(this.jpegPath, (Buffer)genObject);
                    ((Buffer)genObject).release();
                    ((JPEGBuilder)object3).release();
                    this.setMacFileType(this.jpegPath, "JPEG", "MFL2");
                }
                if (this.pngPath != null) {
                    object3 = new PngBuilder();
                    ((PngBuilder)object3).setSerial(this.serial);
                    genObject = new Buffer();
                    ((PngBuilder)object3).setType(n11);
                    ((PngBuilder)object3).setOption(n14);
                    ((PngBuilder)object3).setDitherType(n15);
                    ((PngBuilder)object3).setInterlace(bl13);
                    ((PngBuilder)object3).setSmooth(bl14);
                    ((PngBuilder)object3).setDither(bl15);
                    ((PngBuilder)object3).setGradient(bl16);
                    ((PngBuilder)object3).setColorOptimization(bl17);
                    ((PngBuilder)object3).setPaletteType(n16);
                    ((PngBuilder)object3).setMaxColors(n17);
                    ((PngBuilder)object3).setExactFit(this.exactFit);
                    if (this.bgColor != null) {
                        ((PngBuilder)object3).setBackgroundColor(this.bgColor);
                    }
                    if ((object2 = Mac.getMac()) != null) {
                        string3 = ((Mac)object2).makeSystemPretty(string3);
                    }
                    ((PngBuilder)object3).setFilePalette(string3);
                    if (n12 > 0 && n13 > 0) {
                        ((PngBuilder)object3).setDimensions(n12, n13);
                    }
                    ((PngBuilder)object3).build(buffer, (Buffer)genObject);
                    this.writeBuffer(this.pngPath, (Buffer)genObject);
                    ((Buffer)genObject).release();
                    ((PngBuilder)object3).release();
                    this.setMacFileType(this.pngPath, "PNG", "MOSS");
                }
                if (this.QTMPath != null) {
                    object3 = new byte[]{83, 87, 70, 76, 116, 101, 120, 116};
                    int n18 = buffer.getBufferCount();
                    try {
                        if (this.QTMPath != null) {
                            if (!this.QTMPath.equals("-")) {
                                object2 = new File(this.QTMPath);
                                object = new FileOutputStream((File)object2);
                                ((FileOutputStream)object).write((byte[])object3);
                                int n19 = 0;
                                while (n19 < n18) {
                                    byte[] byArray = buffer.getBuffer(n19);
                                    ((FileOutputStream)object).write(byArray);
                                    ++n19;
                                }
                                ((FileOutputStream)object).close();
                                this.setMacFileType(this.QTMPath, "MooV", "TVOD");
                            } else {
                                ((FilterOutputStream)System.out).write((byte[])object3);
                                int n20 = 0;
                                while (n20 < n18) {
                                    object = buffer.getBuffer(n20);
                                    ((FilterOutputStream)System.out).write((byte[])object);
                                    ++n20;
                                }
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log(this.getResString("OutputFileInvalid") + this.QTMPath);
                    }
                    catch (IOException iOException) {
                        this.log(this.getResString("OutputFileError") + this.QTMPath);
                    }
                    catch (GeneratorApiException generatorApiException) {
                        this.log(this.getResString("OutputFileError") + this.QTMPath);
                    }
                }
                if (this.serverMapPath != null) {
                    object3 = new GifBuilder();
                    genObject = new Buffer();
                    ((GifBuilder)object3).setDither(bl4);
                    ((GifBuilder)object3).setSmooth(bl5);
                    ((GifBuilder)object3).setInterlace(bl6);
                    ((GifBuilder)object3).setTransparent(bl7);
                    ((GifBuilder)object3).setGradient(bl9);
                    ((GifBuilder)object3).setLoopCount(n3);
                    ((GifBuilder)object3).setDitherType(n4);
                    ((GifBuilder)object3).setColorOptimization(bl10);
                    ((GifBuilder)object3).setPaletteType(n5);
                    ((GifBuilder)object3).setQuality(bl11);
                    ((GifBuilder)object3).setMaxColors(n6);
                    if (n > 0 && n2 > 0) {
                        ((GifBuilder)object3).setDimensions(n, n2);
                    }
                    ((GifBuilder)object3).buildImageMap(false, 0, buffer, (Buffer)genObject, null);
                    this.writeBuffer(this.serverMapPath, (Buffer)genObject);
                    ((Buffer)genObject).release();
                }
                if (this.clientMapPath != null) {
                    object3 = new GifBuilder();
                    genObject = new Buffer();
                    ((GifBuilder)object3).setDither(bl4);
                    ((GifBuilder)object3).setSmooth(bl5);
                    ((GifBuilder)object3).setInterlace(bl6);
                    ((GifBuilder)object3).setTransparent(bl7);
                    ((GifBuilder)object3).setGradient(bl9);
                    ((GifBuilder)object3).setLoopCount(n3);
                    ((GifBuilder)object3).setDitherType(n4);
                    ((GifBuilder)object3).setColorOptimization(bl10);
                    ((GifBuilder)object3).setPaletteType(n5);
                    ((GifBuilder)object3).setQuality(bl11);
                    ((GifBuilder)object3).setMaxColors(n6);
                    if (n > 0 && n2 > 0) {
                        ((GifBuilder)object3).setDimensions(n, n2);
                    }
                    ((GifBuilder)object3).buildImageMap(true, 0, buffer, (Buffer)genObject, this.clientMapName);
                    this.writeBuffer(this.clientMapPath, (Buffer)genObject);
                    ((Buffer)genObject).release();
                }
                buffer.release();
            }
            if ((string = flashEnvironment.getMessages()).length() > 0) {
                Date date = new Date();
                this.log(date.toString() + ": " + this.inputPath);
                this.log(string);
            }
        }
        catch (GeneratorApiException generatorApiException) {
            this.log(this.getResString("OutputFileError") + generatorApiException);
        }
        System.runFinalization();
        System.gc();
        return true;
    }

    protected String getResString(String string) {
        return this.resources.getString(string);
    }

    protected void log(String string) {
        if (this.logPath != null && this.logWriter == null && !this.logOpened) {
            try {
                this.logWriter = new PrintWriter(new FileOutputStream(new File(this.logPath)));
            }
            catch (Exception exception) {
                System.err.println(this.getResString("LogFileInvalid") + this.logPath);
            }
            this.logOpened = true;
        }
        if (this.logWriter != null) {
            this.logWriter.println(string);
            this.logWriter.flush();
        } else {
            System.err.println(string);
        }
    }

    protected void usage(boolean bl) {
        if (bl) {
            if (this.serial != null) {
                if (!this.serial.getLimited()) {
                    this.log(this.getResString("Title") + " " + this.getResString("Version") + " " + this.getResString("Build") + " - " + this.getResString("BuildDate"));
                } else {
                    this.log(this.getResString("Title") + " " + this.getResString("Version") + " " + this.getResString("DevBuild") + " - " + this.getResString("BuildDate"));
                }
            } else {
                this.log(this.getResString("Title") + " " + this.getResString("Version") + " " + this.getResString("DevBuild") + " - " + this.getResString("BuildDate"));
            }
            this.log(this.getResString("Copyright"));
            this.log(this.getResString("VerboseUsage"));
        } else {
            this.log(this.getResString("Usage"));
        }
    }

    public int logLevel() {
        return this.logLevel;
    }

    public void logMessage(String string, String string2, String string3) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
        if (string3 == null) {
            string3 = "";
        }
        this.log(resourceBundle.getString(string2) + string3);
    }

    public void logMessage(String string) {
        this.log(string);
    }

    public void init() {
        System.runFinalizersOnExit((boolean)true);
        this.loadResources();
        this.initProperties();
        String string = System.getProperty("com.macromedia.generator.installpath");
        if (string == null) {
            string = "/";
            Properties properties = System.getProperties();
            ((Hashtable)properties).put("com.macromedia.generator.installpath", string);
            this.logMessage("Flash Generator: Install path not found, using default: " + string);
        }
        this.initSerialization();
        this.initCaches();
    }

    public void execute(String[] stringArray) {
        try {
            if (this.processArgs(stringArray)) {
                this.processTemplate();
                this.resetPaths();
            }
        }
        catch (Exception exception) {
            this.resetPaths();
            if (this.logWriter == null) {
                exception.printStackTrace();
            } else {
                exception.printStackTrace(this.logWriter);
            }
        }
        catch (Error error) {
            this.resetPaths();
            if (this.logWriter == null) {
                error.printStackTrace();
            }
            error.printStackTrace(this.logWriter);
        }
    }

    public static void main(String[] stringArray) {
        FlashGeneratorApp flashGeneratorApp = new FlashGeneratorApp();
        flashGeneratorApp.init();
        flashGeneratorApp.execute(stringArray);
        flashGeneratorApp = null;
    }
}

