/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.peer.ProjectorBuilderPeer;
import com.macromedia.generator.platform.Mac;

public class ProjectorBuilder
extends GenObject {
    public ProjectorBuilder() throws GeneratorApiException {
        this.peer = ProjectorBuilderPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected ProjectorBuilder(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            ProjectorBuilderPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            ProjectorBuilderPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void build(Buffer buffer, Buffer buffer2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (buffer.peer == 0 || buffer2.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ProjectorBuilderPeer.Build(this.peer, buffer.peer, buffer2.peer);
        if (n == 0) {
            throw new GeneratorApiException("error building the Proj buffer");
        }
    }

    public void setOS(int n) {
        if (this.peer != 0) {
            ProjectorBuilderPeer.SetOS(this.peer, n);
        }
    }

    public void setPlayerFile(String string) {
        Mac mac = Mac.getMac();
        if (mac != null) {
            String string2 = mac.makeSystemPretty(string);
            if (this.peer != 0) {
                ProjectorBuilderPeer.SetPlayerFile(this.peer, string2);
            }
        } else if (this.peer != 0) {
            ProjectorBuilderPeer.SetPlayerFile(this.peer, string);
        }
    }
}

