/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.peer.GradientPeer;

public class Gradient
extends GenObject {
    public Gradient() throws GeneratorApiException {
        this.peer = GradientPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Gradient(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            GradientPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            GradientPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void addRgb(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = GradientPeer.AddRgb(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error adding rgb");
        }
    }

    public void addColor(int n, Color color) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = GradientPeer.AddColor(this.peer, n, color.peer);
        if (n2 == 0) {
            throw new GeneratorApiException("error adding color");
        }
    }
}

