/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.peer.BufferPeer;

public class Buffer
extends GenObject {
    public Buffer() throws GeneratorApiException {
        this.peer = BufferPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Buffer(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            BufferPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            BufferPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void reset() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BufferPeer.Reset(this.peer);
        if (n == 0) {
            throw new GeneratorApiException("error resetting buffer");
        }
    }

    public byte[] read(int n) throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        byte[] byArray = new byte[n];
        int n2 = BufferPeer.Read(this.peer, byArray, n, nArray);
        if (nArray[0] != n) {
            throw new GeneratorApiException("error reading from buffer");
        }
        if (n2 == 0) {
            throw new GeneratorApiException("error reading from buffer");
        }
        return byArray;
    }

    public void write(byte[] byArray) throws GeneratorApiException {
        int n = byArray.length;
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = BufferPeer.Write(this.peer, byArray, n, nArray);
        if (nArray[0] != n) {
            throw new GeneratorApiException("error writing to buffer");
        }
        if (n2 == 0) {
            throw new GeneratorApiException("error writing to buffer");
        }
    }

    public void seek(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = BufferPeer.Seek(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error seeking in buffer");
        }
    }

    public int getSize() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BufferPeer.GetSize(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting buffer size");
        }
        return nArray[0];
    }

    public int getPos() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BufferPeer.GetPos(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting buffer position");
        }
        return nArray[0];
    }

    public int getBufferCount() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BufferPeer.GetBufferCount(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting buffer count");
        }
        return nArray[0];
    }

    public byte[] getBuffer(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int[] nArray = new int[]{0};
        BufferPeer.GetBufferSize(this.peer, n, nArray);
        if (nArray[0] < 1) {
            throw new GeneratorApiException("invalid buffer");
        }
        byte[] byArray = new byte[nArray[0]];
        BufferPeer.GetBuffer(this.peer, n, byArray);
        return byArray;
    }
}

