/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.peer.BitmapPeer;
import com.macromedia.generator.platform.Mac;

public class Bitmap
extends GenObject {
    public Bitmap() throws GeneratorApiException {
        this.peer = BitmapPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Bitmap(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            BitmapPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            BitmapPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setFile(String string) throws GeneratorApiException {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        Mac mac = Mac.getMac();
        if (mac != null) {
            String string2 = mac.makeSystemPretty(string);
            n = BitmapPeer.SetFile(this.peer, string2);
        } else {
            n = BitmapPeer.SetFile(this.peer, string);
        }
        if (n == 0) {
            throw new GeneratorApiException("error setting file");
        }
    }

    public void setBuffer(Buffer buffer) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (buffer == null) {
            throw new GeneratorApiException("null buffer");
        }
        int n = BitmapPeer.SetBuffer(this.peer, buffer.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting buffer");
        }
    }

    public void setPngFile(String string) throws GeneratorApiException {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        Mac mac = Mac.getMac();
        if (mac != null) {
            String string2 = mac.makeSystemPretty(string);
            n = BitmapPeer.SetPngFile(this.peer, string2);
        } else {
            n = BitmapPeer.SetPngFile(this.peer, string);
        }
        if (n == 0) {
            throw new GeneratorApiException("error setting file");
        }
    }

    public void setPngBuffer(Buffer buffer) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        if (buffer == null) {
            throw new GeneratorApiException("null buffer");
        }
        int n = BitmapPeer.SetPngBuffer(this.peer, buffer.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting buffer");
        }
    }

    public int getWidth() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BitmapPeer.GetWidth(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting width");
        }
        return nArray[0];
    }

    public int getHeight() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BitmapPeer.GetHeight(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting height");
        }
        return nArray[0];
    }

    public Rect getBounds() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BitmapPeer.GetBounds(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting bounds");
        }
        return new Rect(nArray[0]);
    }

    public void setCenter(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n3 = BitmapPeer.SetCenter(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error setting center");
        }
    }

    public void setQuality(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = BitmapPeer.SetQuality(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting quality");
        }
    }

    public int getQuality() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BitmapPeer.GetQuality(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting quality");
        }
        return nArray[0];
    }

    public void setExport(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = BitmapPeer.SetExport(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting export format");
        }
    }

    public int getExport() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = BitmapPeer.GetExport(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting export format");
        }
        return nArray[0];
    }
}

