/*
 * Decompiled with CFR 0.152.
 */
package com.orangefunction.tomcat.redissessions;

import com.orangefunction.tomcat.redissessions.DeserializedSessionContainer;
import com.orangefunction.tomcat.redissessions.RedisSession;
import com.orangefunction.tomcat.redissessions.RedisSessionHandlerValve;
import com.orangefunction.tomcat.redissessions.Serializer;
import com.orangefunction.tomcat.redissessions.SessionSerializationMetadata;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class RedisSessionManager
extends ManagerBase
implements Lifecycle {
    protected byte[] NULL_SESSION = "null".getBytes();
    private final Log log = LogFactory.getLog(RedisSessionManager.class);
    protected String host = "localhost";
    protected int port = 6379;
    protected int database = 0;
    protected String password = null;
    protected int timeout = 2000;
    protected String sentinelMaster = null;
    Set<String> sentinelSet = null;
    protected Pool<Jedis> connectionPool;
    protected JedisPoolConfig connectionPoolConfig = new JedisPoolConfig();
    protected RedisSessionHandlerValve handlerValve;
    protected ThreadLocal<RedisSession> currentSession = new ThreadLocal();
    protected ThreadLocal<SessionSerializationMetadata> currentSessionSerializationMetadata = new ThreadLocal();
    protected ThreadLocal<String> currentSessionId = new ThreadLocal();
    protected ThreadLocal<Boolean> currentSessionIsPersisted = new ThreadLocal();
    protected Serializer serializer;
    protected static String name = "RedisSessionManager";
    protected String serializationStrategyClass = "com.orangefunction.tomcat.redissessions.JavaSerializer";
    protected EnumSet<SessionPersistPolicy> sessionPersistPoliciesSet = EnumSet.of(SessionPersistPolicy.DEFAULT);
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSerializationStrategyClass(String strategy) {
        this.serializationStrategyClass = strategy;
    }

    public String getSessionPersistPolicies() {
        StringBuilder policies = new StringBuilder();
        Iterator iter = this.sessionPersistPoliciesSet.iterator();
        while (iter.hasNext()) {
            SessionPersistPolicy policy = (SessionPersistPolicy)((Object)iter.next());
            policies.append(policy.name());
            if (!iter.hasNext()) continue;
            policies.append(",");
        }
        return policies.toString();
    }

    public void setSessionPersistPolicies(String sessionPersistPolicies) {
        String[] policyArray = sessionPersistPolicies.split(",");
        EnumSet<SessionPersistPolicy> policySet = EnumSet.of(SessionPersistPolicy.DEFAULT);
        String[] stringArray = policyArray;
        int n = policyArray.length;
        int n2 = 0;
        while (n2 < n) {
            String policyName = stringArray[n2];
            SessionPersistPolicy policy = SessionPersistPolicy.fromName(policyName);
            policySet.add(policy);
            ++n2;
        }
        this.sessionPersistPoliciesSet = policySet;
    }

    public boolean getSaveOnChange() {
        return this.sessionPersistPoliciesSet.contains((Object)SessionPersistPolicy.SAVE_ON_CHANGE);
    }

    public boolean getAlwaysSaveAfterRequest() {
        return this.sessionPersistPoliciesSet.contains((Object)SessionPersistPolicy.ALWAYS_SAVE_AFTER_REQUEST);
    }

    public String getSentinels() {
        StringBuilder sentinels = new StringBuilder();
        Iterator<String> iter = this.sentinelSet.iterator();
        while (iter.hasNext()) {
            sentinels.append(iter.next());
            if (!iter.hasNext()) continue;
            sentinels.append(",");
        }
        return sentinels.toString();
    }

    public void setSentinels(String sentinels) {
        if (sentinels == null) {
            sentinels = "";
        }
        String[] sentinelArray = sentinels.split(",");
        this.sentinelSet = new HashSet<String>(Arrays.asList(sentinelArray));
    }

    public Set<String> getSentinelSet() {
        return this.sentinelSet;
    }

    public String getSentinelMaster() {
        return this.sentinelMaster;
    }

    public void setSentinelMaster(String master) {
        this.sentinelMaster = master;
    }

    public int getRejectedSessions() {
        return 0;
    }

    public void setRejectedSessions(int i) {
    }

    protected Jedis acquireConnection() {
        Jedis jedis = (Jedis)this.connectionPool.getResource();
        if (this.getDatabase() != 0) {
            jedis.select(this.getDatabase());
        }
        return jedis;
    }

    protected void returnConnection(Jedis jedis, Boolean error) {
        if (error.booleanValue()) {
            this.connectionPool.returnBrokenResource((Object)jedis);
        } else {
            this.connectionPool.returnResource((Object)jedis);
        }
    }

    protected void returnConnection(Jedis jedis) {
        this.returnConnection(jedis, false);
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        this.setState(LifecycleState.STARTING);
        Boolean attachedToValve = false;
        Valve[] valveArray = this.getContainer().getPipeline().getValves();
        int n = valveArray.length;
        int n2 = 0;
        while (n2 < n) {
            Valve valve = valveArray[n2];
            if (valve instanceof RedisSessionHandlerValve) {
                this.handlerValve = (RedisSessionHandlerValve)valve;
                this.handlerValve.setRedisSessionManager(this);
                this.log.info((Object)"Attached to RedisSessionHandlerValve");
                attachedToValve = true;
                break;
            }
            ++n2;
        }
        if (!attachedToValve.booleanValue()) {
            String error = "Unable to attach to session handling valve; sessions cannot be saved after the request without the valve starting properly.";
            this.log.fatal((Object)error);
            throw new LifecycleException(error);
        }
        try {
            this.initializeSerializer();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.log.fatal((Object)"Unable to load serializer", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        this.log.info((Object)("Will expire sessions after " + this.getMaxInactiveInterval() + " seconds"));
        this.initializeDatabaseConnection();
        this.setDistributable(true);
    }

    protected synchronized void stopInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        try {
            this.connectionPool.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopInternal();
    }

    public Session createSession(String requestedSessionId) {
        RedisSession session = null;
        String sessionId = null;
        String jvmRoute = this.getJvmRoute();
        Boolean error = true;
        Jedis jedis = null;
        try {
            jedis = this.acquireConnection();
            if (requestedSessionId != null) {
                sessionId = requestedSessionId;
                if (jvmRoute != null) {
                    sessionId = String.valueOf(sessionId) + '.' + jvmRoute;
                }
                if (jedis.setnx(sessionId.getBytes(), this.NULL_SESSION) == 0L) {
                    sessionId = null;
                }
            } else {
                do {
                    sessionId = this.generateSessionId();
                    if (jvmRoute == null) continue;
                    sessionId = String.valueOf(sessionId) + '.' + jvmRoute;
                } while (jedis.setnx(sessionId.getBytes(), this.NULL_SESSION) == 0L);
            }
            error = false;
            if (sessionId != null) {
                session = (RedisSession)this.createEmptySession();
                session.setNew(true);
                session.setValid(true);
                session.setCreationTime(System.currentTimeMillis());
                session.setMaxInactiveInterval(this.getMaxInactiveInterval());
                session.setId(sessionId);
                session.tellNew();
            }
            this.currentSession.set(session);
            this.currentSessionId.set(sessionId);
            this.currentSessionIsPersisted.set(false);
            this.currentSessionSerializationMetadata.set(new SessionSerializationMetadata());
            if (session != null) {
                try {
                    error = this.saveInternal(jedis, (Session)session, true);
                }
                catch (IOException ex) {
                    this.log.error((Object)("Error saving newly created session: " + ex.getMessage()));
                    this.currentSession.set(null);
                    this.currentSessionId.set(null);
                    session = null;
                }
            }
        }
        finally {
            if (jedis != null) {
                this.returnConnection(jedis, error);
            }
        }
        return session;
    }

    public Session createEmptySession() {
        return new RedisSession((Manager)this);
    }

    public void add(Session session) {
        try {
            this.save(session);
        }
        catch (IOException ex) {
            this.log.warn((Object)("Unable to add to session manager store: " + ex.getMessage()));
            throw new RuntimeException("Unable to add to session manager store.", ex);
        }
    }

    public Session findSession(String id) throws IOException {
        RedisSession session = null;
        if (id == null) {
            this.currentSessionIsPersisted.set(false);
            this.currentSession.set(null);
            this.currentSessionSerializationMetadata.set(null);
            this.currentSessionId.set(null);
        } else if (id.equals(this.currentSessionId.get())) {
            session = this.currentSession.get();
        } else {
            byte[] data = this.loadSessionDataFromRedis(id);
            if (data != null) {
                DeserializedSessionContainer container = this.sessionFromSerializedData(id, data);
                session = container.session;
                this.currentSession.set(session);
                this.currentSessionSerializationMetadata.set(container.metadata);
                this.currentSessionIsPersisted.set(true);
                this.currentSessionId.set(id);
            } else {
                this.currentSessionIsPersisted.set(false);
                this.currentSession.set(null);
                this.currentSessionSerializationMetadata.set(null);
                this.currentSessionId.set(null);
            }
        }
        return session;
    }

    public void clear() {
        Jedis jedis = null;
        Boolean error = true;
        try {
            jedis = this.acquireConnection();
            jedis.flushDB();
            error = false;
        }
        finally {
            if (jedis != null) {
                this.returnConnection(jedis, error);
            }
        }
    }

    public int getSize() throws IOException {
        Jedis jedis = null;
        Boolean error = true;
        try {
            jedis = this.acquireConnection();
            int size = jedis.dbSize().intValue();
            error = false;
            int n = size;
            return n;
        }
        finally {
            if (jedis != null) {
                this.returnConnection(jedis, error);
            }
        }
    }

    public String[] keys() throws IOException {
        Jedis jedis = null;
        Boolean error = true;
        try {
            jedis = this.acquireConnection();
            Set keySet = jedis.keys("*");
            error = false;
            String[] stringArray = keySet.toArray(new String[keySet.size()]);
            return stringArray;
        }
        finally {
            if (jedis != null) {
                this.returnConnection(jedis, error);
            }
        }
    }

    public byte[] loadSessionDataFromRedis(String id) throws IOException {
        Jedis jedis = null;
        Boolean error = true;
        try {
            this.log.trace((Object)("Attempting to load session " + id + " from Redis"));
            jedis = this.acquireConnection();
            byte[] data = jedis.get(id.getBytes());
            error = false;
            if (data == null) {
                this.log.trace((Object)("Session " + id + " not found in Redis"));
            }
            byte[] byArray = data;
            if (jedis != null) {
                this.returnConnection(jedis, error);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            if (jedis != null) {
                this.returnConnection(jedis, error);
            }
            throw throwable;
        }
    }

    public DeserializedSessionContainer sessionFromSerializedData(String id, byte[] data) throws IOException {
        this.log.trace((Object)("Deserializing session " + id + " from Redis"));
        if (Arrays.equals(this.NULL_SESSION, data)) {
            this.log.error((Object)("Encountered serialized session " + id + " with data equal to NULL_SESSION. This is a bug."));
            throw new IOException("Serialized session data was equal to NULL_SESSION");
        }
        RedisSession session = null;
        SessionSerializationMetadata metadata = new SessionSerializationMetadata();
        try {
            session = (RedisSession)this.createEmptySession();
            this.serializer.deserializeInto(data, session, metadata);
            session.setId(id);
            session.setNew(false);
            session.setMaxInactiveInterval(this.getMaxInactiveInterval() * 1000);
            session.access();
            session.setValid(true);
            session.resetDirtyTracking();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Session Contents [" + id + "]:"));
                Enumeration en = session.getAttributeNames();
                while (en.hasMoreElements()) {
                    this.log.trace((Object)("  " + en.nextElement()));
                }
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.fatal((Object)"Unable to deserialize into session", (Throwable)ex);
            throw new IOException("Unable to deserialize into session", ex);
        }
        return new DeserializedSessionContainer(session, metadata);
    }

    public void save(Session session) throws IOException {
        this.save(session, false);
    }

    public void save(Session session, boolean forceSave) throws IOException {
        Jedis jedis = null;
        Boolean error = true;
        try {
            jedis = this.acquireConnection();
            error = this.saveInternal(jedis, session, forceSave);
        }
        finally {
            if (jedis != null) {
                this.returnConnection(jedis, error);
            }
        }
    }

    protected boolean saveInternal(Jedis jedis, Session session, boolean forceSave) throws IOException {
        Boolean error = true;
        try {
            try {
                Boolean isCurrentSessionPersisted;
                this.log.trace((Object)("Saving session " + session + " into Redis"));
                RedisSession redisSession = (RedisSession)session;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Session Contents [" + redisSession.getId() + "]:"));
                    Enumeration en = redisSession.getAttributeNames();
                    while (en.hasMoreElements()) {
                        this.log.trace((Object)("  " + en.nextElement()));
                    }
                }
                byte[] binaryId = redisSession.getId().getBytes();
                SessionSerializationMetadata sessionSerializationMetadata = this.currentSessionSerializationMetadata.get();
                byte[] originalSessionAttributesHash = sessionSerializationMetadata.getSessionAttributesHash();
                byte[] sessionAttributesHash = null;
                if (forceSave || redisSession.isDirty().booleanValue() || (isCurrentSessionPersisted = this.currentSessionIsPersisted.get()) == null || !isCurrentSessionPersisted.booleanValue() || !Arrays.equals(originalSessionAttributesHash, sessionAttributesHash = this.serializer.attributesHashFrom(redisSession))) {
                    this.log.trace((Object)"Save was determined to be necessary");
                    if (sessionAttributesHash == null) {
                        sessionAttributesHash = this.serializer.attributesHashFrom(redisSession);
                    }
                    SessionSerializationMetadata updatedSerializationMetadata = new SessionSerializationMetadata();
                    updatedSerializationMetadata.setSessionAttributesHash(sessionAttributesHash);
                    jedis.set(binaryId, this.serializer.serializeFrom(redisSession, updatedSerializationMetadata));
                    redisSession.resetDirtyTracking();
                    this.currentSessionSerializationMetadata.set(updatedSerializationMetadata);
                    this.currentSessionIsPersisted.set(true);
                } else {
                    this.log.trace((Object)"Save was determined to be unnecessary");
                }
                this.log.trace((Object)("Setting expire timeout on session [" + redisSession.getId() + "] to " + this.getMaxInactiveInterval()));
                jedis.expire(binaryId, this.getMaxInactiveInterval());
                error = false;
                error.booleanValue();
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage());
                throw e;
            }
        }
        catch (Throwable throwable) {}
        return error;
    }

    public void remove(Session session) {
        this.remove(session, false);
    }

    public void remove(Session session, boolean update) {
        Jedis jedis = null;
        Boolean error = true;
        this.log.trace((Object)("Removing session ID : " + session.getId()));
        try {
            jedis = this.acquireConnection();
            jedis.del(session.getId());
            error = false;
        }
        finally {
            if (jedis != null) {
                this.returnConnection(jedis, error);
            }
        }
    }

    public void afterRequest() {
        block7: {
            RedisSession redisSession = this.currentSession.get();
            if (redisSession != null) {
                try {
                    try {
                        if (redisSession.isValid()) {
                            this.log.trace((Object)("Request with session completed, saving session " + redisSession.getId()));
                            this.save((Session)redisSession, this.getAlwaysSaveAfterRequest());
                            break block7;
                        }
                        this.log.trace((Object)("HTTP Session has been invalidated, removing :" + redisSession.getId()));
                        this.remove((Session)redisSession);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Error storing/removing session", (Throwable)e);
                        this.currentSession.remove();
                        this.currentSessionId.remove();
                        this.currentSessionIsPersisted.remove();
                        this.log.trace((Object)("Session removed from ThreadLocal :" + redisSession.getIdInternal()));
                    }
                }
                finally {
                    this.currentSession.remove();
                    this.currentSessionId.remove();
                    this.currentSessionIsPersisted.remove();
                    this.log.trace((Object)("Session removed from ThreadLocal :" + redisSession.getIdInternal()));
                }
            }
        }
    }

    public void processExpires() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeDatabaseConnection() throws LifecycleException {
        try {
            if (this.getSentinelMaster() != null) {
                Set<String> sentinelSet = this.getSentinelSet();
                if (sentinelSet == null || sentinelSet.size() <= 0) throw new LifecycleException("Error configuring Redis Sentinel connection pool: expected both `sentinelMaster` and `sentiels` to be configured");
                this.connectionPool = new JedisSentinelPool(this.getSentinelMaster(), sentinelSet, (GenericObjectPoolConfig)this.connectionPoolConfig, this.getTimeout(), this.getPassword());
                return;
            } else {
                this.connectionPool = new JedisPool((GenericObjectPoolConfig)this.connectionPoolConfig, this.getHost(), this.getPort(), this.getTimeout(), this.getPassword());
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LifecycleException("Error connecting to Redis", (Throwable)e);
        }
    }

    private void initializeSerializer() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.log.info((Object)("Attempting to use serializer :" + this.serializationStrategyClass));
        this.serializer = (Serializer)Class.forName(this.serializationStrategyClass).newInstance();
        Loader loader = null;
        if (this.getContainer() != null) {
            loader = this.getContainer().getLoader();
        }
        ClassLoader classLoader = null;
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        this.serializer.setClassLoader(classLoader);
    }

    public int getConnectionPoolMaxTotal() {
        return this.connectionPoolConfig.getMaxTotal();
    }

    public void setConnectionPoolMaxTotal(int connectionPoolMaxTotal) {
        this.connectionPoolConfig.setMaxTotal(connectionPoolMaxTotal);
    }

    public int getConnectionPoolMaxIdle() {
        return this.connectionPoolConfig.getMaxIdle();
    }

    public void setConnectionPoolMaxIdle(int connectionPoolMaxIdle) {
        this.connectionPoolConfig.setMaxIdle(connectionPoolMaxIdle);
    }

    public int getConnectionPoolMinIdle() {
        return this.connectionPoolConfig.getMinIdle();
    }

    public void setConnectionPoolMinIdle(int connectionPoolMinIdle) {
        this.connectionPoolConfig.setMinIdle(connectionPoolMinIdle);
    }

    public boolean getLifo() {
        return this.connectionPoolConfig.getLifo();
    }

    public void setLifo(boolean lifo) {
        this.connectionPoolConfig.setLifo(lifo);
    }

    public long getMaxWaitMillis() {
        return this.connectionPoolConfig.getMaxWaitMillis();
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.connectionPoolConfig.setMaxWaitMillis(maxWaitMillis);
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.connectionPoolConfig.getMinEvictableIdleTimeMillis();
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.connectionPoolConfig.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public long getSoftMinEvictableIdleTimeMillis() {
        return this.connectionPoolConfig.getSoftMinEvictableIdleTimeMillis();
    }

    public void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.connectionPoolConfig.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
    }

    public int getNumTestsPerEvictionRun() {
        return this.connectionPoolConfig.getNumTestsPerEvictionRun();
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.connectionPoolConfig.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public boolean getTestOnCreate() {
        return this.connectionPoolConfig.getTestOnCreate();
    }

    public void setTestOnCreate(boolean testOnCreate) {
        this.connectionPoolConfig.setTestOnCreate(testOnCreate);
    }

    public boolean getTestOnBorrow() {
        return this.connectionPoolConfig.getTestOnBorrow();
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.connectionPoolConfig.setTestOnBorrow(testOnBorrow);
    }

    public boolean getTestOnReturn() {
        return this.connectionPoolConfig.getTestOnReturn();
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.connectionPoolConfig.setTestOnReturn(testOnReturn);
    }

    public boolean getTestWhileIdle() {
        return this.connectionPoolConfig.getTestWhileIdle();
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.connectionPoolConfig.setTestWhileIdle(testWhileIdle);
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.connectionPoolConfig.getTimeBetweenEvictionRunsMillis();
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.connectionPoolConfig.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public String getEvictionPolicyClassName() {
        return this.connectionPoolConfig.getEvictionPolicyClassName();
    }

    public void setEvictionPolicyClassName(String evictionPolicyClassName) {
        this.connectionPoolConfig.setEvictionPolicyClassName(evictionPolicyClassName);
    }

    public boolean getBlockWhenExhausted() {
        return this.connectionPoolConfig.getBlockWhenExhausted();
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.connectionPoolConfig.setBlockWhenExhausted(blockWhenExhausted);
    }

    public boolean getJmxEnabled() {
        return this.connectionPoolConfig.getJmxEnabled();
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.connectionPoolConfig.setJmxEnabled(jmxEnabled);
    }

    public String getJmxNameBase() {
        return this.connectionPoolConfig.getJmxNameBase();
    }

    public void setJmxNameBase(String jmxNameBase) {
        this.connectionPoolConfig.setJmxNameBase(jmxNameBase);
    }

    public String getJmxNamePrefix() {
        return this.connectionPoolConfig.getJmxNamePrefix();
    }

    public void setJmxNamePrefix(String jmxNamePrefix) {
        this.connectionPoolConfig.setJmxNamePrefix(jmxNamePrefix);
    }

    static enum SessionPersistPolicy {
        DEFAULT,
        SAVE_ON_CHANGE,
        ALWAYS_SAVE_AFTER_REQUEST;


        static SessionPersistPolicy fromName(String name) {
            SessionPersistPolicy[] sessionPersistPolicyArray = SessionPersistPolicy.values();
            int n = sessionPersistPolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                SessionPersistPolicy policy = sessionPersistPolicyArray[n2];
                if (policy.name().equalsIgnoreCase(name)) {
                    return policy;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid session persist policy [" + name + "]. Must be one of " + Arrays.asList(SessionPersistPolicy.values()) + ".");
        }
    }
}

