/*
 * Decompiled with CFR 0.152.
 */
package com.smartmarmot.orabbix;

import com.smartmarmot.common.SmartLogger;
import com.smartmarmot.orabbix.Configurator;
import com.smartmarmot.orabbix.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Level;

public class Querybox {
    private Query[] _query;
    private String _dbname;
    private String _queriesfile;
    private String _extraqueriesfile;

    public Querybox(String _localdbname, String _prp, String _extraprp) {
        try {
            if (Configurator.propVerify(_prp)) {
                this.setQueriesFile(_prp);
            }
            if (Configurator.propVerify(_extraprp)) {
                this.setExtraQueriesFile(_extraprp);
            }
            if (_localdbname.length() > 0 && _localdbname != null) {
                this.setDBName(_localdbname);
            }
            this.refresh();
        }
        catch (Exception e) {
            SmartLogger.logThis(Level.ERROR, "Error on QueryBox " + e.getMessage());
        }
    }

    public String getDBName() {
        return this._dbname;
    }

    public Query[] getQueries() {
        return this._query;
    }

    public String getQueriesFile() {
        return this._queriesfile;
    }

    public void refresh() {
        try {
            Properties prp;
            Query[] firstq = null;
            Query[] extraq = null;
            if (this._queriesfile != null) {
                prp = Configurator.getPropsFromFile(this._queriesfile);
                firstq = Configurator.getQueries(prp);
            }
            if (this._extraqueriesfile != null) {
                prp = Configurator.getPropsFromFile(this._extraqueriesfile);
                extraq = Configurator.getQueries(prp);
            }
            Query[] refreshedq = null;
            refreshedq = this._extraqueriesfile != null ? this.addQueries(firstq, extraq) : firstq;
            if (this._query == null) {
                this.setQueries(refreshedq);
            } else {
                for (int i = 0; i < refreshedq.length; ++i) {
                    for (int j = 0; j < this._query.length; ++j) {
                        if (!this._query[j].getName().equals(refreshedq[i].getName())) continue;
                        refreshedq[i].setNextrun(this._query[j].getNextrun());
                    }
                }
                this.setQueries(refreshedq);
            }
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Querybox " + ex);
        }
    }

    public void setDBName(String _dbname) {
        this._dbname = _dbname;
    }

    public void setQueries(Query[] _query) {
        this._query = null;
        this._query = _query;
    }

    public Query[] addQueries(Query[] _originalquery, Query[] _newquery) {
        ArrayList<Query> tempOriginalArray = new ArrayList<Query>(Arrays.asList(_originalquery));
        ArrayList<Query> tempNewArray = new ArrayList<Query>(Arrays.asList(_newquery));
        for (int i = 0; i < _originalquery.length; ++i) {
            for (int j = 0; j < _newquery.length; ++j) {
                if (!_originalquery[i].getName().equals(_newquery[j].getName())) continue;
                tempOriginalArray.remove(_originalquery[i]);
                tempOriginalArray.add(_newquery[j]);
                tempNewArray.remove(_newquery[j]);
            }
        }
        tempOriginalArray.addAll(tempNewArray);
        Query[] queries = tempOriginalArray.toArray(new Query[0]);
        return queries;
    }

    public void setQueriesFile(String _queriesfile) {
        this._queriesfile = _queriesfile;
    }

    public void setExtraQueriesFile(String _extraqueriesfile) {
        this._extraqueriesfile = _extraqueriesfile;
    }
}

