/*
 * Decompiled with CFR 0.152.
 */
package com.smartmarmot.orabbix;

import com.smartmarmot.common.SmartLogger;
import com.smartmarmot.common.db.DBConn;
import com.smartmarmot.orabbix.Query;
import com.smartmarmot.orabbix.Querybox;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Level;

public class Configurator {
    private static Properties _props;

    protected static Properties getPropsFromFile(String _filename) {
        try {
            Configurator.verifyConfig();
            Properties propsq = new Properties();
            if (_filename != "" && _filename != null) {
                File queryFile = new File(_filename);
                FileInputStream fisq = new FileInputStream(new File(queryFile.getAbsoluteFile().getCanonicalPath()));
                queryFile = null;
                SmartLogger.logThis(Level.DEBUG, "Loaded the properties from " + _filename);
                propsq.load(fisq);
                fisq.close();
                return propsq;
            }
        }
        catch (Exception e) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator reading properties file getPropsFromFile(" + _filename + ") " + e.getMessage());
            return null;
        }
        return null;
    }

    protected static Query[] getQueries(Properties _propsq) throws Exception {
        return Configurator.getQueries("QueryList", _propsq);
    }

    private static Query[] getQueries(String parameter, Properties _propsq) throws Exception {
        try {
            StringTokenizer stq = new StringTokenizer(_propsq.getProperty(parameter), ",");
            String[] QueryLists = new String[stq.countTokens()];
            int count = 0;
            while (stq.hasMoreTokens()) {
                String token;
                QueryLists[count] = token = stq.nextToken().toString().trim();
                ++count;
            }
            ArrayList<Query> Queries = new ArrayList<Query>();
            for (int i = 0; i < QueryLists.length; ++i) {
                try {
                    Query q = Configurator.getQueryProperties(_propsq, QueryLists[i]);
                    Queries.add(q);
                    continue;
                }
                catch (Exception e1) {
                    SmartLogger.logThis(Level.ERROR, "Error on Configurator on reading query " + QueryLists[i] + e1);
                    SmartLogger.logThis(Level.INFO, "Query " + QueryLists[i] + " skipped due to error " + e1);
                }
            }
            Query[] queries = Queries.toArray(new Query[0]);
            return queries;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator on reading properties file " + _propsq.toString() + " getQueries(" + parameter + "," + _propsq.toString() + ") " + ex.getMessage());
            return null;
        }
    }

    private static Query getQueryProperties(Properties _propsq, String _queryName) throws Exception {
        try {
            String query = "";
            try {
                query = new String(_propsq.getProperty(_queryName + "." + "Query"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.ERROR, "Error while getting " + _queryName + "." + "Query" + " " + ex.getMessage());
            }
            String noDataFound = "";
            try {
                noDataFound = new String(_propsq.getProperty(_queryName + "." + "NoDataFound"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "NoDataFound" + " null or not present " + ex.getMessage());
            }
            String whenNotAlive = "";
            try {
                whenNotAlive = new String(_propsq.getProperty(_queryName + "." + "WhenNotAlive"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "WhenNotAlive" + " null or not present " + ex.getMessage());
            }
            String raceCondQuery = "";
            try {
                raceCondQuery = new String(_propsq.getProperty(_queryName + "." + "RaceConditionQuery"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "RaceConditionQuery" + " null or not present " + ex.getMessage());
            }
            String raceCondValue = "";
            try {
                raceCondValue = new String(_propsq.getProperty(_queryName + "." + "RaceConditionValue"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "RaceConditionValue" + " null or not present " + ex.getMessage());
            }
            int period = -1;
            try {
                period = new Integer(_propsq.getProperty(_queryName + "." + "Period"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "Period" + " null or not present " + ex.getMessage());
                try {
                    period = new Integer(_propsq.getProperty("DefaultQueryPeriod"));
                }
                catch (Exception ex1) {
                    SmartLogger.logThis(Level.DEBUG, "Note: DefaultQueryPeriod null or not present using default values 2 min.");
                    period = 2;
                }
            }
            Boolean active = true;
            try {
                String active_str = _propsq.getProperty(_queryName + "." + "Active");
                if (active_str != null && active_str.equalsIgnoreCase("false")) {
                    active = false;
                }
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "Active" + " null or not present " + ex.getMessage());
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "Active" + " null or not present using default values TRUE");
            }
            Boolean trim = true;
            try {
                String trim_str = _propsq.getProperty(_queryName + "." + "Trim");
                if (trim_str != null && trim_str.equalsIgnoreCase("false")) {
                    trim = false;
                }
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "Trim" + " null or not present " + ex.getMessage());
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "Trim" + " null or not present using default values TRUE");
            }
            Boolean space = false;
            try {
                String space_str = _propsq.getProperty(_queryName + "." + "AddSpaces");
                if (space_str != null && space_str.equalsIgnoreCase("false")) {
                    space = false;
                }
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "AddSpaces" + " null or not present " + ex.getMessage());
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "AddSpaces" + " null or not present using default values TRUE");
            }
            ArrayList<Integer> excludeColumns = new ArrayList<Integer>();
            try {
                String excludeColumnsList = new String(_propsq.getProperty(_queryName + "." + "ExcludeColumnsList"));
                StringTokenizer st = new StringTokenizer(excludeColumnsList, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().toString();
                    Integer tmpInteger = new Integer(token);
                    excludeColumns.add(tmpInteger);
                }
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "ExcludeColumnsList" + " error " + ex.getMessage());
            }
            ArrayList<Integer> raceExcludeColumns = new ArrayList<Integer>();
            try {
                String excludeColumnsList = new String(_propsq.getProperty(_queryName + "." + "RaceConditionQueryExcludeColumnsList"));
                StringTokenizer st = new StringTokenizer(excludeColumnsList, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().toString();
                    Integer tmpInteger = new Integer(token);
                    excludeColumns.add(tmpInteger);
                }
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + _queryName + "." + "RaceConditionQueryExcludeColumnsList" + " error " + ex.getMessage());
            }
            Query q = new Query(query, _queryName, noDataFound, whenNotAlive, raceCondQuery, raceCondValue, period, active, trim, space, excludeColumns, raceExcludeColumns);
            return q;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator on getQueryProperties(" + _propsq.toString() + ") " + ex.getMessage());
            return null;
        }
    }

    private static void verifyConfig() {
        if (_props == null) {
            throw new IllegalArgumentException("empty properties");
        }
    }

    public Configurator(String _url) throws IOException {
        Properties props = new Properties();
        try {
            try {
                File configFile = new File(_url);
                FileInputStream fis = new FileInputStream(new File(configFile.getAbsoluteFile().getCanonicalPath()));
                props.load(fis);
                fis.close();
            }
            catch (Exception e) {
                SmartLogger.logThis(Level.ERROR, "Error on Configurator while retriving configuration file " + _url + " " + e.getMessage());
            }
            _props = props;
        }
        catch (Exception e) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator " + e.getMessage());
        }
    }

    private DBConn getConnection(String dbName) throws Exception {
        try {
            int r;
            Configurator.verifyConfig();
            SmartLogger.logThis(Level.DEBUG, "getConnection for database " + dbName);
            String url = "";
            try {
                url = new String(_props.getProperty(dbName + "." + "Url"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.ERROR, "Error on Configurator getConnection while getting " + dbName + "." + "Url" + " " + ex.getMessage());
            }
            String uname = "";
            try {
                uname = new String(_props.getProperty(dbName + "." + "User"));
            }
            catch (Exception ex) {
                try {
                    SmartLogger.logThis(Level.DEBUG, "Error on Configurator getConnection while getting " + dbName + "." + "User" + " " + ex.getMessage());
                    uname = new String(_props.getProperty("DefaultUser"));
                }
                catch (Exception ex1) {
                    SmartLogger.logThis(Level.ERROR, "Error on Configurator getConnection while getting DefaultUser " + ex1.getMessage());
                }
            }
            String password = "";
            try {
                password = new String(_props.getProperty(dbName + "." + "Password"));
            }
            catch (Exception ex) {
                try {
                    SmartLogger.logThis(Level.DEBUG, "Error on Configurator getConnection while getting " + dbName + "." + "Password" + " " + ex.getMessage());
                    password = new String(_props.getProperty("DefaultPassword"));
                }
                catch (Exception ex1) {
                    SmartLogger.logThis(Level.ERROR, "Error on Configurator getConnection while getting " + dbName + "." + "Password" + " " + ex.getMessage());
                }
            }
            DriverAdapterCPDS cpds = new DriverAdapterCPDS();
            cpds.setDriver("oracle.jdbc.OracleDriver");
            cpds.setUrl(url.toString());
            cpds.setUser(uname.toString());
            cpds.setPassword(password.toString());
            SharedPoolDataSource tds = new SharedPoolDataSource();
            tds.setConnectionPoolDataSource((ConnectionPoolDataSource)cpds);
            Integer maxActive = new Integer(5);
            try {
                maxActive = new Integer(_props.getProperty(dbName + "." + "MaxActive"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + dbName + "." + "MaxActive" + " " + ex.getMessage());
                try {
                    maxActive = new Integer(_props.getProperty("DatabaseList.MaxActive"));
                }
                catch (Exception e) {
                    SmartLogger.logThis(Level.WARN, "Note: DatabaseList.MaxActive " + e.getMessage());
                    SmartLogger.logThis(Level.WARN, "Warning I will use default value " + maxActive);
                }
            }
            tds.setMaxActive(maxActive.intValue());
            Integer maxWait = new Integer(100);
            try {
                maxWait = new Integer(_props.getProperty(dbName + "." + "MaxWait"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + dbName + "." + "MaxWait" + " " + ex.getMessage());
                try {
                    maxWait = new Integer(_props.getProperty("DatabaseList.MaxWait"));
                }
                catch (Exception e) {
                    SmartLogger.logThis(Level.WARN, "Note: DatabaseList.MaxWait " + e.getMessage());
                    SmartLogger.logThis(Level.WARN, "Warning I will use default value " + maxWait);
                }
            }
            tds.setMaxWait(maxWait.intValue());
            Integer maxIdle = new Integer(1);
            try {
                maxIdle = new Integer(_props.getProperty(dbName + "." + "MaxIdle"));
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Note: " + dbName + "." + "MaxIdle" + " " + ex.getMessage());
                try {
                    maxIdle = new Integer(_props.getProperty("DatabaseList.MaxIdle"));
                }
                catch (Exception e) {
                    SmartLogger.logThis(Level.WARN, "Note: DatabaseList.MaxIdle " + e.getMessage());
                    SmartLogger.logThis(Level.WARN, "Warning I will use default value " + maxIdle);
                }
            }
            tds.setMaxIdle(maxIdle.intValue());
            SmartLogger.logThis(Level.INFO, "DB Pool created: " + tds);
            SmartLogger.logThis(Level.INFO, "URL=" + url.toString());
            SmartLogger.logThis(Level.INFO, "maxPoolSize=" + tds.getMaxActive());
            SmartLogger.logThis(Level.INFO, "maxIdleSize=" + tds.getMaxIdle());
            SmartLogger.logThis(Level.INFO, "maxIdleTime=" + tds.getMinEvictableIdleTimeMillis() + "ms");
            SmartLogger.logThis(Level.INFO, "poolTimeout=" + tds.getMaxWait());
            SmartLogger.logThis(Level.INFO, "timeBetweenEvictionRunsMillis=" + tds.getTimeBetweenEvictionRunsMillis());
            SmartLogger.logThis(Level.INFO, "numTestsPerEvictionRun=" + tds.getNumTestsPerEvictionRun());
            tds.setValidationQuery("SELECT SYSDATE FROM DUAL");
            Connection con = null;
            con = tds.getConnection();
            PreparedStatement p_stmt = null;
            p_stmt = con.prepareStatement("SELECT SYS_CONTEXT ('USERENV', 'SESSION_USER') FROM DUAL");
            ResultSet rs = null;
            rs = p_stmt.executeQuery();
            String tempStr = new String("");
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rs.next()) {
                for (r = 1; r < numColumns + 1; ++r) {
                    tempStr = tempStr + rs.getObject(r).toString().trim();
                }
            }
            SmartLogger.logThis(Level.INFO, "Connected as " + tempStr);
            con.close();
            con = null;
            con = tds.getConnection();
            p_stmt = con.prepareStatement("SELECT SYS_CONTEXT ('USERENV', 'DB_NAME') FROM DUAL");
            rs = p_stmt.executeQuery();
            rsmd = rs.getMetaData();
            numColumns = rsmd.getColumnCount();
            tempStr = "";
            while (rs.next()) {
                for (r = 1; r < numColumns + 1; ++r) {
                    tempStr = tempStr + rs.getObject(r).toString().trim();
                }
            }
            SmartLogger.logThis(Level.INFO, "--------- on Database -> " + tempStr);
            con.close();
            con = null;
            DBConn mydbconn = new DBConn(tds, dbName.toString());
            return mydbconn;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator for database " + dbName + " -->" + ex.getMessage());
            return null;
        }
    }

    public DBConn[] getConnections() throws Exception {
        try {
            Configurator.verifyConfig();
            String[] DatabaseList = this.getDBList();
            ArrayList<DBConn> connections = new ArrayList<DBConn>();
            for (int i = 0; i < DatabaseList.length; ++i) {
                DBConn dbc = this.getConnection(DatabaseList[i]);
                if (dbc != null) {
                    connections.add(dbc);
                    continue;
                }
                SmartLogger.logThis(Level.INFO, "This Database " + DatabaseList[i] + " removed");
            }
            DBConn[] connArray = connections.toArray(new DBConn[0]);
            return connArray;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator getConnections " + ex.getMessage());
            return null;
        }
    }

    public String[] getDBList() throws Exception {
        try {
            Configurator.verifyConfig();
            String dblist = "";
            try {
                dblist = new String(_props.getProperty("DatabaseList"));
            }
            catch (Exception e) {
                SmartLogger.logThis(Level.ERROR, "Error on Configurator while retriving the databases list DatabaseList " + e);
            }
            StringTokenizer st = new StringTokenizer(dblist, ",");
            String[] DatabaseList = new String[st.countTokens()];
            int count = 0;
            while (st.hasMoreTokens()) {
                String token;
                DatabaseList[count] = token = st.nextToken().toString();
                ++count;
            }
            return DatabaseList;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator while retriving the databases list DatabaseList " + ex);
            return null;
        }
    }

    public Integer getMaxThread() throws Exception {
        try {
            Configurator.verifyConfig();
            return new Integer(_props.getProperty("OrabbixDaemon.MaxThreadNumber"));
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator while retriving the OrabbixDaemon.MaxThreadNumber " + ex);
            return null;
        }
    }

    public String getPidFile() throws Exception {
        try {
            Configurator.verifyConfig();
            String _pidfile = new String(_props.getProperty("OrabbixDaemon.PidFile"));
            SmartLogger.logThis(Level.INFO, "PidFile -> " + _pidfile);
            if (_pidfile == "") {
                SmartLogger.logThis(Level.ERROR, "Error retrieving pidfile from " + _props);
            }
            return _pidfile;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator getPidFile " + ex);
            return null;
        }
    }

    public static String getQueryFile() {
        String queryFile = new String(_props.getProperty("QueryListFile"));
        return queryFile;
    }

    public static String getQueryFile(String dbName) {
        try {
            Configurator.verifyConfig();
            if (_props.getProperty(dbName + "." + "QueryListFile") != null) {
                return _props.getProperty(dbName + "." + "QueryListFile");
            }
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator on getQueryFile(" + dbName + ") " + ex.getMessage());
            SmartLogger.logThis(Level.WARN, "I'm going to return getQueryFile() ");
            return Configurator.getQueryFile();
        }
        return null;
    }

    public static String getExtraQueryFile(String dbName) {
        try {
            Configurator.verifyConfig();
            if (_props.getProperty(dbName + "." + "ExtraQueryListFile") != null) {
                return _props.getProperty(dbName + "." + "ExtraQueryListFile");
            }
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator on getExtraQueryFile(" + dbName + ") " + ex.getMessage());
        }
        return null;
    }

    public Properties getQueryProp() {
        Configurator.verifyConfig();
        Properties propsq = new Properties();
        try {
            String fiqp = new String(_props.getProperty("QueryListFile"));
            File queryFile = new File(fiqp);
            FileInputStream fisq = new FileInputStream(new File(queryFile.getAbsoluteFile().getCanonicalPath()));
            queryFile = null;
            propsq.load(fisq);
            fisq.close();
        }
        catch (Exception e) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator  while getting QueryListFile error -> " + e.getMessage());
            return null;
        }
        return propsq;
    }

    public Properties getQueryProp(String dbname) {
        try {
            FileInputStream fisq;
            Configurator.verifyConfig();
            Properties propsq = new Properties();
            if (dbname != "" && dbname != null) {
                File queryFile = new File(_props.getProperty(dbname + "." + "QueryListFile"));
                fisq = new FileInputStream(new File(queryFile.getAbsoluteFile().getCanonicalPath()));
                queryFile = null;
                SmartLogger.logThis(Level.DEBUG, "Debug loaded the " + dbname + "." + "QueryListFile");
            } else {
                SmartLogger.logThis(Level.DEBUG, "Debug I'm loading the default QueryListFile " + dbname + " don't have it's own");
                File queryFile = new File(_props.getProperty("QueryListFile"));
                fisq = new FileInputStream(new File(queryFile.getAbsoluteFile().getCanonicalPath()));
                queryFile = null;
            }
            propsq.load(fisq);
            fisq.close();
            return propsq;
        }
        catch (Exception e) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator getting QueryListFile " + dbname + e.getMessage());
            return null;
        }
    }

    public String getZabbixServer() throws Exception {
        try {
            Configurator.verifyConfig();
            return _props.getProperty("Address");
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator while retriving zabbix server host Address or port Port " + ex);
            return null;
        }
    }

    public int getZabbixServerPort() throws Exception {
        try {
            Configurator.verifyConfig();
            Integer port = new Integer(_props.getProperty("Port"));
            return port;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator while retriving zabbix server port Port " + ex);
            SmartLogger.logThis(Level.WARN, "I will use the default port 10051");
            return 10051;
        }
    }

    public Hashtable<String, Integer> getZabbixServers() throws Exception {
        String zxblist = new String();
        try {
            zxblist = new String(_props.getProperty("ZabbixServerList"));
        }
        catch (Exception e) {
            SmartLogger.logThis(Level.ERROR, "Error on getZabbixServers while getting ZabbixServerList " + e.getMessage());
        }
        StringTokenizer st = new StringTokenizer(zxblist, ",");
        Hashtable<String, Integer> ZabbixServers = new Hashtable<String, Integer>();
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().toString();
            String server = new String();
            try {
                server = new String(_props.getProperty(token + "." + "Address"));
            }
            catch (Exception e) {
                SmartLogger.logThis(Level.ERROR, "Error on getZabbixServers while getting " + token + "." + "Address" + " " + e.getMessage());
            }
            Integer port = new Integer(10051);
            try {
                port = new Integer(_props.getProperty(token + "." + "Port"));
            }
            catch (Exception e) {
                SmartLogger.logThis(Level.WARN, "Warning on getZabbixServers while getting " + token + "." + "Port" + " " + e.getMessage());
                SmartLogger.logThis(Level.WARN, "Warning I will use the default port" + port);
            }
            ZabbixServers.put(server, port);
            ++count;
        }
        return ZabbixServers;
    }

    public static boolean hasQueryFile(String dbName) {
        if (dbName == null) {
            return false;
        }
        try {
            Configurator.verifyConfig();
            if (_props.getProperty(dbName + "." + "QueryListFile") != null) {
                return true;
            }
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator gettingQueryListFile" + dbName + ex.getMessage());
            return false;
        }
        return false;
    }

    public static boolean hasExtraQueryFile(String dbName) {
        if (dbName == null) {
            return false;
        }
        try {
            Configurator.verifyConfig();
            if (_props.getProperty(dbName + "." + "ExtraQueryListFile") != null) {
                return true;
            }
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator gettingExtraQueryListFile" + dbName + ex.getMessage());
            return false;
        }
        return false;
    }

    public boolean isEqualsDBList(DBConn[] _dbc) throws Exception {
        try {
            Configurator.verifyConfig();
            String[] localdblist = this.getDBList();
            String[] remotedblist = new String[_dbc.length];
            for (int i = 0; i < _dbc.length; ++i) {
                remotedblist[i] = _dbc[i].getName();
            }
            return ArrayUtils.isEquals((Object)localdblist, (Object)remotedblist);
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator while comparing the databases lists on isEqualsDBList " + ex);
            return false;
        }
    }

    public DBConn[] rebuildDBList(DBConn[] _dbc) {
        try {
            Configurator.verifyConfig();
            Object[] localdblist = this.getDBList();
            Object[] remotedblist = new String[_dbc.length];
            for (int i = 0; i < _dbc.length; ++i) {
                remotedblist[i] = _dbc[i].getName();
            }
            ArrayList<DBConn> connections = new ArrayList<DBConn>();
            for (int j = 0; j < localdblist.length; ++j) {
                DBConn tmpDBConn;
                if (ArrayUtils.contains((Object[])remotedblist, (Object)localdblist[j])) {
                    tmpDBConn = _dbc[ArrayUtils.indexOf((Object[])remotedblist, (Object)localdblist[j])];
                    connections.add(tmpDBConn);
                }
                if (ArrayUtils.contains((Object[])remotedblist, (Object)localdblist[j])) continue;
                SmartLogger.logThis(Level.INFO, "New database founded! " + (String)localdblist[j]);
                tmpDBConn = this.getConnection((String)localdblist[j]);
                if (tmpDBConn == null) continue;
                connections.add(tmpDBConn);
            }
            for (int x = 0; x < _dbc.length; ++x) {
                if (ArrayUtils.contains((Object[])localdblist, (Object)_dbc[x].getName())) continue;
                SmartLogger.logThis(Level.WARN, "Database " + _dbc[x].getName() + " removed from configuration file");
                _dbc[x].getSPDS().close();
                SmartLogger.logThis(Level.WARN, "Database " + _dbc[x].getName() + " conections closed");
                _dbc[x] = null;
            }
            DBConn[] connArray = connections.toArray(new DBConn[0]);
            return connArray;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator while retriving the databases list DatabaseList error:" + ex);
            return _dbc;
        }
    }

    public static Integer getSleep() throws Exception {
        try {
            Configurator.verifyConfig();
            Integer sleep = new Integer(5);
            try {
                sleep = new Integer(_props.getProperty("OrabbixDaemon.Sleep"));
            }
            catch (Exception e) {
                SmartLogger.logThis(Level.WARN, "Warning while getting OrabbixDaemon.Sleep I will use the default " + sleep);
            }
            return sleep;
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on Configurator while retriving OrabbixDaemon.Sleep " + ex);
            return null;
        }
    }

    public static boolean propVerify(String _prop) {
        if (_prop != null && !_prop.isEmpty() && !_prop.equals("")) {
            Properties props = new Properties();
            File queryFile = new File(_prop);
            try {
                FileInputStream fisq = new FileInputStream(new File(queryFile.getAbsoluteFile().getCanonicalPath()));
                props.load(fisq);
                fisq.close();
                return true;
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.DEBUG, "Error on Configurator while checking file " + _prop + " " + ex);
                return false;
            }
        }
        return false;
    }

    public static Querybox buildQueryBoxbyDBName(String dbname) {
        String queryFile = null;
        String extraQueryFile = null;
        queryFile = Configurator.hasQueryFile(dbname) ? Configurator.getQueryFile(dbname) : Configurator.getQueryFile();
        if (Configurator.hasExtraQueryFile(dbname)) {
            extraQueryFile = Configurator.getExtraQueryFile(dbname);
        }
        Querybox qboxtmp = new Querybox(dbname, queryFile, extraQueryFile);
        return qboxtmp;
    }
}

