/*
 * Decompiled with CFR 0.152.
 */
package com.smartmarmot.common.db;

import com.smartmarmot.common.SmartLogger;
import com.smartmarmot.orabbix.Query;
import com.smartmarmot.zabbix.ZabbixItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Level;

public class DBEnquiry {
    public static String ask(String _query, Connection _con, String queryName, String dbName, Boolean trim, Boolean space, List<Integer> _excludeColumns) {
        String tempStr = "";
        try {
            ResultSet rs = null;
            PreparedStatement p_stmt = _con.prepareStatement(_query);
            rs = p_stmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rs.next()) {
                for (int r = 1; r < numColumns + 1; ++r) {
                    Integer tmpInteger = new Integer(r);
                    if (_excludeColumns.contains(tmpInteger)) continue;
                    tempStr = trim != false ? tempStr + rs.getObject(r).toString().trim() : tempStr + rs.getObject(r).toString();
                    if (!space.booleanValue() || r >= numColumns) continue;
                    tempStr = tempStr + ' ';
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.ERROR, "Error on DBEnquiry while closing resultset " + ex.getMessage() + " on database=" + dbName);
            }
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.WARN, "Error while executing ->" + queryName + "- on database ->" + dbName + "- Exception received " + ex.getMessage());
            tempStr = null;
        }
        return tempStr;
    }

    public static ZabbixItem[] execute(Query[] _queries, Connection _conn, String dbname) {
        if (_queries == null || _queries.length < 1) {
            throw new IllegalArgumentException("Query's array is empty or null");
        }
        Connection con = _conn;
        ArrayList<ZabbixItem> SZItems = new ArrayList<ZabbixItem>();
        for (int i = 0; i < _queries.length; ++i) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            String datetime = dateFormat.format(_queries[i].getNextrun());
            String tempStr = new String("");
            try {
                Date nextRun;
                Date now;
                if (!_queries[i].getActive().booleanValue() || !(now = new Date(System.currentTimeMillis())).after(nextRun = _queries[i].getNextrun())) continue;
                Date newNextRun = new Date(nextRun.getTime() + (long)(_queries[i].getPeriod() * 1000 * 60));
                _queries[i].setNextrun(newNextRun);
                datetime = dateFormat.format(_queries[i].getNextrun());
                SmartLogger.logThis(Level.DEBUG, "Actual query is " + _queries[i].getName() + "Nextrun " + datetime + " on database=" + dbname + " Period=" + _queries[i].getPeriod());
                boolean racecond = true;
                String result = "";
                if (_queries[i].getRaceQuery() != null && _queries[i].getRaceQuery().length() > 0) {
                    SmartLogger.logThis(Level.DEBUG, "INFO:" + _queries[i].getName() + " RaceCondiftionQuery ->" + _queries[i].getRaceQuery());
                    result = DBEnquiry.ask(_queries[i].getRaceQuery(), _conn, _queries[i].getName() + "RaceConditionQuery", dbname, _queries[i].getTrim(), _queries[i].getSpace(), _queries[i].getRaceExcludeColumnsList());
                    if (result != null && _queries[i].getRaceValue() != null && !result.equalsIgnoreCase(_queries[i].getRaceValue())) {
                        racecond = false;
                    }
                }
                result = "";
                if (!racecond) continue;
                result = DBEnquiry.ask(_queries[i].getSQL().toString(), _conn, _queries[i].getName(), dbname, _queries[i].getTrim(), _queries[i].getSpace(), _queries[i].getExcludeColumnsList());
                if (result == null) {
                    if (_queries[i].getNoData().length() > 0 && _queries[i].getNoData() != null) {
                        result = _queries[i].getNoData();
                    }
                } else if (result.length() == 0 && _queries[i].getNoData().length() > 0 && _queries[i].getNoData() != null) {
                    result = _queries[i].getNoData();
                }
                ZabbixItem zitem = new ZabbixItem(_queries[i].getName(), result, dbname);
                SZItems.add(zitem);
                SmartLogger.logThis(Level.DEBUG, "I'm going to return " + result + " for query " + _queries[i].getName() + " on database=" + dbname);
                continue;
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.ERROR, "Error on DBEnquiry on query=" + _queries[i].getName() + " on database=" + dbname + " Error returned is " + ex);
                if (_queries[i].getNoData() != null) {
                    if (_queries[i].getNoData().length() > 0) {
                        tempStr = _queries[i].getNoData();
                    }
                } else {
                    tempStr = "";
                }
                ZabbixItem zitem = new ZabbixItem(_queries[i].getName(), tempStr, dbname);
                SZItems.add(zitem);
                SmartLogger.logThis(Level.DEBUG, "I'm going to return " + tempStr + " for query " + _queries[i].getName() + " on database=" + dbname);
            }
        }
        try {
            if (!con.isClosed()) {
                con.close();
            }
        }
        catch (Exception ex) {
            SmartLogger.logThis(Level.ERROR, "Error on DBEnquiry while closing connection " + ex.getMessage() + " on database=" + dbname);
        }
        ZabbixItem[] items = SZItems.toArray(new ZabbixItem[0]);
        return items;
    }
}

