/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.types.Type;

public class StatementDML
extends StatementDMQL {
    Expression[] targets;
    Expression updatableTableCheck;
    RangeVariable checkRangeVariable;
    boolean isTruncate;
    boolean isSimpleInsert;
    int generatedType;
    ResultMetaData generatedInputMetaData;
    int[] generatedIndexes;
    ResultMetaData generatedResultMetaData;

    public StatementDML(int n, int n2, HsqlNameManager.HsqlName hsqlName) {
        super(n, n2, hsqlName);
    }

    StatementDML(Session session, Table table, RangeVariable[] rangeVariableArray, ParserDQL.CompileContext compileContext, boolean bl, int n) {
        super(19, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.baseTable = table.getBaseTable() == null ? table : table.getBaseTable();
        this.targetRangeVariables = rangeVariableArray;
        this.restartIdentity = bl;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        if (n == 1205) {
            this.isTruncate = true;
        }
        this.targetRangeVariables[0].addAllColumns();
    }

    StatementDML(Session session, Expression[] expressionArray, Table table, RangeVariable[] rangeVariableArray, int[] nArray, Expression[] expressionArray2, boolean[] blArray, ParserDQL.CompileContext compileContext) {
        super(82, 2004, session.getCurrentSchemaHsqlName());
        this.targets = expressionArray;
        this.targetTable = table;
        this.baseTable = table.getBaseTable() == null ? table : table.getBaseTable();
        this.updateColumnMap = nArray;
        this.updateExpressions = expressionArray2;
        this.updateCheckColumns = blArray;
        this.targetRangeVariables = rangeVariableArray;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
        this.targetRangeVariables[0].addAllColumns();
    }

    StatementDML(Session session, Expression[] expressionArray, RangeVariable[] rangeVariableArray, int[] nArray, int[] nArray2, boolean[] blArray, Expression expression, Expression expression2, Expression[] expressionArray2, ParserDQL.CompileContext compileContext) {
        super(128, 2004, session.getCurrentSchemaHsqlName());
        this.targets = expressionArray;
        this.sourceTable = rangeVariableArray[0].rangeTable;
        this.targetTable = rangeVariableArray[1].rangeTable;
        this.baseTable = this.targetTable.isTriggerUpdatable() ? this.targetTable : this.targetTable.getBaseTable();
        this.insertCheckColumns = blArray;
        this.insertColumnMap = nArray;
        this.updateColumnMap = nArray2;
        this.insertExpression = expression2;
        this.updateExpressions = expressionArray2;
        this.targetRangeVariables = rangeVariableArray;
        this.condition = expression;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
    }

    StatementDML() {
        super(81, 2004, null);
    }

    void setupChecks() {
        if (this.targetTable != this.baseTable) {
            QuerySpecification querySpecification = ((TableDerived)this.targetTable).getQueryExpression().getMainSelect();
            this.updatableTableCheck = querySpecification.checkQueryCondition;
            this.checkRangeVariable = querySpecification.rangeVariables[0];
        }
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        switch (this.type) {
            case 82: {
                result = this.executeUpdateStatement(session);
                break;
            }
            case 128: {
                result = this.executeMergeStatement(session);
                break;
            }
            case 19: {
                if (this.isTruncate) {
                    result = this.executeDeleteTruncateStatement(session);
                    break;
                }
                result = this.executeDeleteStatement(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementDML");
            }
        }
        return result;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        SchemaObject schemaObject;
        int n;
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(orderedHashSet, false);
        } else if (!this.baseTable.isTemp()) {
            block5: for (n = 0; n < this.baseTable.fkConstraints.length; ++n) {
                schemaObject = this.baseTable.fkConstraints[n];
                switch (this.type) {
                    case 82: {
                        if (!ArrayUtil.haveCommonElement(((Constraint)schemaObject).getRefColumns(), this.updateColumnMap)) continue block5;
                        orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                        continue block5;
                    }
                    case 50: {
                        orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                        continue block5;
                    }
                    case 128: {
                        if (this.updateColumnMap != null && ArrayUtil.haveCommonElement(((Constraint)schemaObject).getRefColumns(), this.updateColumnMap)) {
                            orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                        }
                        if (this.insertExpression == null) continue block5;
                        orderedHashSet.add(this.baseTable.fkConstraints[n].getMain().getName());
                    }
                }
            }
            if (this.type == 82 || this.type == 128) {
                this.baseTable.collectFKReadLocks(this.updateColumnMap, orderedHashSet);
            } else if (this.type == 19) {
                this.baseTable.collectFKReadLocks(null, orderedHashSet);
            }
            this.getTriggerTableNames(orderedHashSet, false);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            schemaObject = this.rangeVariables[n].rangeTable;
            HsqlNameManager.HsqlName hsqlName = ((Table)schemaObject).getName();
            if (((Table)schemaObject).isReadOnly() || ((Table)schemaObject).isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
        if (this.baseTable.isView()) {
            this.getTriggerTableNames(orderedHashSet, true);
        } else if (!this.baseTable.isTemp()) {
            orderedHashSet.add(this.baseTable.getName());
            if (this.type == 82 || this.type == 128) {
                if (this.updateExpressions.length != 0) {
                    this.baseTable.collectFKWriteLocks(this.updateColumnMap, orderedHashSet);
                }
            } else if (this.type == 19) {
                this.baseTable.collectFKWriteLocks(null, orderedHashSet);
            }
            this.getTriggerTableNames(orderedHashSet, true);
        }
    }

    @Override
    public void setGeneratedColumnInfo(int n, ResultMetaData resultMetaData) {
        if (this.type != 50) {
            return;
        }
        int n2 = this.baseTable.getIdentityColumnIndex();
        this.generatedType = n;
        this.generatedInputMetaData = resultMetaData;
        switch (n) {
            case 2: {
                return;
            }
            case 21: {
                this.generatedIndexes = resultMetaData.getGeneratedColumnIndexes();
                for (int i = 0; i < this.generatedIndexes.length; ++i) {
                    if (this.generatedIndexes[i] >= 0 && this.generatedIndexes[i] < this.baseTable.getColumnCount()) continue;
                    throw Error.error(5501);
                }
                break;
            }
            case 1: {
                int n3;
                if (this.baseTable.hasGeneratedColumn()) {
                    if (n2 > 0) {
                        int n4 = ArrayUtil.countTrueElements(this.baseTable.colGenerated) + 1;
                        this.generatedIndexes = new int[n4];
                        int n5 = 0;
                        for (n3 = 0; n3 < this.baseTable.colGenerated.length; ++n3) {
                            if (!this.baseTable.colGenerated[n3] && n3 != n2) continue;
                            this.generatedIndexes[n5++] = n3;
                        }
                        break;
                    }
                    this.generatedIndexes = ArrayUtil.booleanArrayToIntIndexes(this.baseTable.colGenerated);
                    break;
                }
                if (n2 >= 0) {
                    this.generatedIndexes = new int[]{n2};
                    break;
                }
                return;
            }
            case 11: {
                int n3;
                String[] stringArray = resultMetaData.getGeneratedColumnNames();
                this.generatedIndexes = this.baseTable.getColumnIndexes(stringArray);
                for (n3 = 0; n3 < this.generatedIndexes.length; ++n3) {
                    if (this.generatedIndexes[n3] >= 0) continue;
                    throw Error.error(5501, stringArray[0]);
                }
                break;
            }
        }
        this.generatedResultMetaData = ResultMetaData.newResultMetaData(this.generatedIndexes.length);
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            ColumnSchema columnSchema = this.baseTable.getColumn(this.generatedIndexes[i]);
            this.generatedResultMetaData.columns[i] = columnSchema;
        }
        this.generatedResultMetaData.prepareData();
        this.isSimpleInsert = false;
    }

    Object[] getGeneratedColumns(Object[] objectArray) {
        if (this.generatedIndexes == null) {
            return null;
        }
        Object[] objectArray2 = new Object[this.generatedIndexes.length];
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            objectArray2[i] = objectArray[this.generatedIndexes[i]];
        }
        return objectArray2;
    }

    @Override
    public boolean hasGeneratedColumns() {
        return this.generatedIndexes != null;
    }

    @Override
    public ResultMetaData generatedResultMetaData() {
        return this.generatedResultMetaData;
    }

    void getTriggerTableNames(OrderedHashSet orderedHashSet, boolean bl) {
        block6: for (int i = 0; i < this.baseTable.triggerList.length; ++i) {
            TriggerDef triggerDef = this.baseTable.triggerList[i];
            switch (this.type) {
                case 50: {
                    if (triggerDef.getStatementType() != 50) continue block6;
                    break;
                }
                case 82: {
                    if (triggerDef.getStatementType() != 82) continue block6;
                    break;
                }
                case 19: {
                    if (triggerDef.getStatementType() != 19) continue block6;
                    break;
                }
                case 128: {
                    if (triggerDef.getStatementType() != 50 && triggerDef.getStatementType() != 82) continue block6;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "StatementDML");
                }
            }
            if (triggerDef.routine == null) continue;
            if (bl) {
                orderedHashSet.addAll(triggerDef.routine.getTableNamesForWrite());
                continue;
            }
            orderedHashSet.addAll(triggerDef.routine.getTableNamesForRead());
        }
    }

    Result executeUpdateStatement(Session session) {
        int n = 0;
        Expression[] expressionArray = this.updateExpressions;
        RowSetNavigatorDataChange rowSetNavigatorDataChange = new RowSetNavigatorDataChange(session.database.sqlEnforceTDCD, session.database.sqlEnforceTDCU);
        Type[] typeArray = this.baseTable.getColumnTypes();
        RangeIterator rangeIterator = RangeVariable.getIterator(session, this.targetRangeVariables);
        Result result = null;
        RowSetNavigator rowSetNavigator = null;
        if (this.generatedIndexes != null) {
            result = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator = result.getChainedResult().getNavigator();
        }
        while (rangeIterator.next()) {
            session.sessionData.startRowProcessing();
            Row row = rangeIterator.getCurrentRow();
            Object[] objectArray = row.getData();
            Object[] objectArray2 = StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, expressionArray, typeArray, objectArray);
            if (this.updatableTableCheck != null) {
                rangeIterator.setCurrent(objectArray2);
                boolean bl = this.updatableTableCheck.testCondition(session);
                if (!bl) {
                    rangeIterator.release();
                    throw Error.error(5700);
                }
            }
            rowSetNavigatorDataChange.addRow(session, row, objectArray2, typeArray, this.updateColumnMap);
        }
        rangeIterator.release();
        rowSetNavigatorDataChange.beforeFirst();
        n = this.update(session, this.baseTable, rowSetNavigatorDataChange, rowSetNavigator);
        if (result == null) {
            if (n == 1) {
                return Result.updateOneResult;
            }
            if (n == 0) {
                return Result.updateZeroResult;
            }
            return new Result(1, n);
        }
        result.setUpdateCount(n);
        return result;
    }

    static Object[] getUpdatedData(Session session, Expression[] expressionArray, Table table, int[] nArray, Expression[] expressionArray2, Type[] typeArray, Object[] objectArray) {
        Object[] objectArray2 = table.getEmptyRowData();
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        int n = 0;
        int n2 = 0;
        while (n < nArray.length) {
            Cloneable cloneable;
            int n3;
            Expression expression;
            if ((expression = expressionArray2[n2++]).getType() == 25) {
                Object[] objectArray3 = expression.getRowValue(session);
                int n4 = 0;
                while (n4 < objectArray3.length) {
                    n3 = nArray[n];
                    cloneable = expression.nodes[n4];
                    if (table.identityColumn != n3 || cloneable.getType() != 1 || cloneable.valueData != null) {
                        if (cloneable.getType() == 4) {
                            if (table.identityColumn != n3) {
                                objectArray2[n3] = table.colDefaults[n3].getValue(session);
                            }
                        } else {
                            objectArray2[n3] = typeArray[n3].convertToType(session, objectArray3[n4], cloneable.dataType);
                        }
                    }
                    ++n4;
                    ++n;
                }
                continue;
            }
            if (expression.getType() == 22) {
                Object[] objectArray4 = expression.getRowValue(session);
                int n5 = 0;
                while (n5 < objectArray4.length) {
                    n3 = nArray[n];
                    cloneable = expression.subQuery.queryExpression.getMetaData().columnTypes[n5];
                    objectArray2[n3] = typeArray[n3].convertToType(session, objectArray4[n5], (Type)cloneable);
                    ++n5;
                    ++n;
                }
                continue;
            }
            int n6 = nArray[n];
            if (expression.getType() == 4) {
                if (table.identityColumn == n6) {
                    ++n;
                    continue;
                }
                objectArray2[n6] = table.colDefaults[n6].getValue(session);
                ++n;
                continue;
            }
            Object object = expression.getValue(session);
            objectArray2[n6] = expressionArray[n].getType() == 99 ? ((ExpressionAccessor)expressionArray[n]).getUpdatedArray(session, (Object[])objectArray2[n6], object, true) : typeArray[n6].convertToType(session, object, expression.dataType);
            ++n;
        }
        return objectArray2;
    }

    Result executeMergeStatement(Session session) {
        int n;
        Type[] typeArray = this.baseTable.getColumnTypes();
        Result result = null;
        RowSetNavigator rowSetNavigator = null;
        if (this.generatedIndexes != null) {
            result = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            rowSetNavigator = result.getChainedResult().getNavigator();
        }
        int n2 = 0;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient(8);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = new RowSetNavigatorDataChange(session.database.sqlEnforceTDCD, session.database.sqlEnforceTDCU);
        RangeVariable[] rangeVariableArray = this.targetRangeVariables;
        RangeIterator[] rangeIteratorArray = new RangeIterator[rangeVariableArray.length];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            rangeIteratorArray[n] = rangeVariableArray[n].getIterator(session);
        }
        n = 0;
        while (n >= 0) {
            Object[] objectArray;
            RangeIterator rangeIterator = rangeIteratorArray[n];
            boolean bl = rangeIterator.isBeforeFirst();
            if (rangeIterator.next()) {
                if (n < rangeVariableArray.length - 1) {
                    ++n;
                    continue;
                }
            } else {
                if (n == 1 && bl && this.insertExpression != null && (objectArray = this.getInsertData(session, typeArray, this.insertExpression.nodes[0].nodes)) != null) {
                    rowSetNavigatorClient.add(objectArray);
                }
                rangeIterator.reset();
                --n;
                continue;
            }
            if (this.updateExpressions.length == 0) continue;
            objectArray = rangeIterator.getCurrentRow();
            session.sessionData.startRowProcessing();
            Object[] objectArray2 = StatementDML.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, typeArray, objectArray.getData());
            try {
                rowSetNavigatorDataChange.addRow(session, (Row)objectArray, objectArray2, typeArray, this.updateColumnMap);
            }
            catch (HsqlException hsqlException) {
                for (int i = 0; i < rangeVariableArray.length; ++i) {
                    rangeIteratorArray[i].reset();
                }
                throw Error.error(3201);
            }
        }
        for (n = 0; n < rangeVariableArray.length; ++n) {
            rangeIteratorArray[n].reset();
        }
        if (this.updateExpressions.length != 0) {
            n2 = this.update(session, this.baseTable, rowSetNavigatorDataChange, rowSetNavigator);
        }
        if (rowSetNavigatorClient.getSize() > 0) {
            this.insertRowSet(session, rowSetNavigator, rowSetNavigatorClient);
            n2 += rowSetNavigatorClient.getSize();
        }
        if (this.insertExpression != null && this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, rowSetNavigatorClient);
        }
        if (result == null) {
            if (n2 == 1) {
                return Result.updateOneResult;
            }
            return new Result(1, n2);
        }
        result.setUpdateCount(n2);
        return result;
    }

    void insertRowSet(Session session, RowSetNavigator rowSetNavigator, RowSetNavigator rowSetNavigator2) {
        Object[] objectArray;
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        RangeVariable.RangeIteratorMain rangeIteratorMain = null;
        if (this.updatableTableCheck != null) {
            rangeIteratorMain = this.checkRangeVariable.getIterator(session);
        }
        rowSetNavigator2.beforeFirst();
        if (this.baseTable.triggerLists[6].length > 0) {
            while (rowSetNavigator2.hasNext()) {
                objectArray = rowSetNavigator2.getNext();
                this.baseTable.fireTriggers(session, 6, null, objectArray, null);
            }
            rowSetNavigator2.beforeFirst();
        }
        while (rowSetNavigator2.hasNext()) {
            objectArray = rowSetNavigator2.getNext();
            this.baseTable.insertSingleRow(session, persistentStore, objectArray, null);
            if (rangeIteratorMain != null) {
                rangeIteratorMain.setCurrent(objectArray);
                boolean bl = this.updatableTableCheck.testCondition(session);
                if (!bl) {
                    throw Error.error(5700);
                }
            }
            if (rowSetNavigator == null) continue;
            Object[] objectArray2 = this.getGeneratedColumns(objectArray);
            rowSetNavigator.add(objectArray2);
        }
        rowSetNavigator2.beforeFirst();
        while (rowSetNavigator2.hasNext()) {
            objectArray = rowSetNavigator2.getNext();
            StatementDML.performIntegrityChecks(session, this.baseTable, null, objectArray, null);
        }
        rowSetNavigator2.beforeFirst();
        if (this.baseTable.triggerLists[3].length > 0) {
            while (rowSetNavigator2.hasNext()) {
                objectArray = rowSetNavigator2.getNext();
                this.baseTable.fireTriggers(session, 3, null, objectArray, null);
            }
            rowSetNavigator2.beforeFirst();
        }
    }

    Result insertSingleRow(Session session, PersistentStore persistentStore, Object[] objectArray) {
        if (this.baseTable.triggerLists[6].length > 0) {
            this.baseTable.fireTriggers(session, 6, null, objectArray, null);
        }
        this.baseTable.insertSingleRow(session, persistentStore, objectArray, null);
        StatementDML.performIntegrityChecks(session, this.baseTable, null, objectArray, null);
        if (session.database.isReferentialIntegrity()) {
            int n = this.baseTable.fkConstraints.length;
            for (int i = 0; i < n; ++i) {
                this.baseTable.fkConstraints[i].checkInsert(session, this.baseTable, objectArray, true);
            }
        }
        if (this.baseTable.triggerLists[3].length > 0) {
            this.baseTable.fireTriggers(session, 3, null, objectArray, null);
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, null);
        }
        return Result.updateOneResult;
    }

    Object[] getInsertData(Session session, Type[] typeArray, Expression[] expressionArray) {
        Object[] objectArray = this.baseTable.getNewRowData(session);
        session.sessionData.startRowProcessing();
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            int n = this.insertColumnMap[i];
            if (expression.opType == 4) {
                if (this.baseTable.identityColumn == n || this.baseTable.colDefaults[n] == null) continue;
                objectArray[n] = this.baseTable.colDefaults[n].getValue(session);
                continue;
            }
            Object object = expression.getValue(session);
            Type type = typeArray[n];
            if (session.database.sqlSyntaxMys || session.database.sqlSyntaxPgs) {
                try {
                    object = type.convertToType(session, object, expression.dataType);
                }
                catch (HsqlException hsqlException) {
                    if (type.typeCode == 91) {
                        object = Type.SQL_TIMESTAMP.convertToType(session, object, expression.dataType);
                        object = type.convertToType(session, object, Type.SQL_TIMESTAMP);
                    }
                    if (type.typeCode == 93) {
                        object = Type.SQL_DATE.convertToType(session, object, expression.dataType);
                        object = type.convertToType(session, object, Type.SQL_DATE);
                    }
                    throw hsqlException;
                }
            } else {
                object = type.convertToType(session, object, expression.dataType);
            }
            objectArray[n] = object;
        }
        return objectArray;
    }

    int update(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange, RowSetNavigator rowSetNavigator) {
        int n;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        Object[] objectArray2;
        int n2;
        int n3 = rowSetNavigatorDataChange.getSize();
        for (n2 = 0; n2 < n3; ++n2) {
            rowSetNavigatorDataChange.next();
            Object[] objectArray3 = rowSetNavigatorDataChange.getCurrentChangedData();
            table.setIdentityColumn(session, objectArray3);
            table.setGeneratedColumns(session, objectArray3);
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            HashSet hashSet = session.sessionContext.getConstraintPath();
            for (int i = 0; i < n3; ++i) {
                objectArray2 = rowSetNavigatorDataChange.getNextRow();
                object3 = rowSetNavigatorDataChange.getCurrentChangedData();
                StatementDML.performReferentialActions(session, table, rowSetNavigatorDataChange, (Row)objectArray2, (Object[])object3, this.updateColumnMap, hashSet);
                hashSet.clear();
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        for (n2 = 0; n2 < rowSetNavigatorDataChange.getSize(); ++n2) {
            Row row = rowSetNavigatorDataChange.getNextRow();
            objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            object2 = (Table)row.getTable();
            if (object2 instanceof TableDerived) {
                object2 = ((TableDerived)object2).view;
            }
            if (object2.triggerLists[8].length <= 0) continue;
            object2.fireTriggers(session, 8, row.getData(), objectArray2, (int[])object3);
            object2.enforceRowConstraints(session, objectArray2);
        }
        if (table.isView) {
            return n3;
        }
        rowSetNavigatorDataChange.beforeFirst();
        for (n2 = 0; n2 < rowSetNavigatorDataChange.getSize(); ++n2) {
            Row row = rowSetNavigatorDataChange.getNextRow();
            objectArray2 = (Table)row.getTable();
            object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            session.addDeleteAction((Table)objectArray2, row, (int[])object3);
        }
        rowSetNavigatorDataChange.beforeFirst();
        for (n2 = 0; n2 < rowSetNavigatorDataChange.getSize(); ++n2) {
            Row row = rowSetNavigatorDataChange.getNextRow();
            objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            object3 = (Table)row.getTable();
            object2 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            objectArray = ((Table)object3).getRowStore(session);
            if (objectArray2 == null) continue;
            object = ((Table)object3).insertSingleRow(session, (PersistentStore)objectArray, objectArray2, (int[])object2);
            if (rowSetNavigator == null) continue;
            Object[] objectArray4 = this.getGeneratedColumns(objectArray2);
            rowSetNavigator.add(objectArray4);
        }
        rowSetNavigatorDataChange.beforeFirst();
        BaseHashMap baseHashMap = null;
        boolean bl = table.triggerLists[5].length > 0;
        for (n = 0; n < rowSetNavigatorDataChange.getSize(); ++n) {
            object3 = rowSetNavigatorDataChange.getNextRow();
            object2 = (Table)((Row)object3).getTable();
            objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
            object = rowSetNavigatorDataChange.getCurrentChangedColumns();
            StatementDML.performIntegrityChecks(session, (Table)object2, ((Row)object3).getData(), objectArray, (int[])object);
            if (object2 == table) continue;
            if (baseHashMap == null) {
                baseHashMap = new OrderedHashSet();
            }
            ((HashSet)baseHashMap).add(object2);
            if (object2.triggerLists[5].length <= 0) continue;
            bl = true;
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (bl) {
            for (n = 0; n < rowSetNavigatorDataChange.getSize(); ++n) {
                object3 = rowSetNavigatorDataChange.getNextRow();
                object2 = rowSetNavigatorDataChange.getCurrentChangedData();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedColumns();
                object = (Table)((Row)object3).getTable();
                ((Table)object).fireTriggers(session, 5, ((Row)object3).getData(), (Object[])object2, (int[])objectArray);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        this.baseTable.fireTriggers(session, 2, rowSetNavigatorDataChange);
        if (baseHashMap != null) {
            for (n = 0; n < baseHashMap.size(); ++n) {
                object3 = (Table)((OrderedHashSet)baseHashMap).get(n);
                ((Table)object3).fireTriggers(session, 2, rowSetNavigatorDataChange);
            }
        }
        return n3;
    }

    Result executeDeleteStatement(Session session) {
        int n = 0;
        RangeIterator rangeIterator = RangeVariable.getIterator(session, this.targetRangeVariables);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = new RowSetNavigatorDataChange(session.database.sqlEnforceTDCD, session.database.sqlEnforceTDCU);
        while (rangeIterator.next()) {
            Row row = rangeIterator.getCurrentRow();
            rowSetNavigatorDataChange.addRow(row);
        }
        rangeIterator.release();
        if (rowSetNavigatorDataChange.getSize() <= 0) {
            return Result.updateZeroResult;
        }
        n = this.delete(session, this.baseTable, rowSetNavigatorDataChange);
        if (n == 1) {
            return Result.updateOneResult;
        }
        return new Result(1, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result executeDeleteTruncateStatement(Session session) {
        PersistentStore persistentStore = this.targetTable.getRowStore(session);
        RowIterator rowIterator = this.targetTable.getPrimaryIndex().firstRow(persistentStore);
        try {
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                session.addDeleteAction((Table)row.getTable(), row, null);
            }
            if (this.restartIdentity && this.targetTable.identitySequence != null) {
                this.targetTable.identitySequence.reset();
            }
        }
        finally {
            rowIterator.release();
        }
        return Result.updateOneResult;
    }

    int delete(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object[] objectArray;
        Object object5;
        int n;
        Object object6;
        int n2 = rowSetNavigatorDataChange.getSize();
        rowSetNavigatorDataChange.beforeFirst();
        if (table.fkMainConstraints.length > 0) {
            object6 = session.sessionContext.getConstraintPath();
            for (n = 0; n < n2; ++n) {
                rowSetNavigatorDataChange.next();
                object5 = rowSetNavigatorDataChange.getCurrentRow();
                StatementDML.performReferentialActions(session, table, rowSetNavigatorDataChange, (Row)object5, null, null, (HashSet)object6);
                ((BaseHashMap)object6).clear();
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        while (rowSetNavigatorDataChange.hasNext()) {
            rowSetNavigatorDataChange.next();
            object6 = rowSetNavigatorDataChange.getCurrentRow();
            Object[] objectArray2 = rowSetNavigatorDataChange.getCurrentChangedData();
            object5 = rowSetNavigatorDataChange.getCurrentChangedColumns();
            objectArray = (Object[])((Row)object6).getTable();
            if (objectArray instanceof TableDerived) {
                objectArray = ((TableDerived)objectArray).view;
            }
            if (objectArray2 == null) {
                objectArray.fireTriggers(session, 7, ((Row)object6).getData(), null, null);
                continue;
            }
            objectArray.fireTriggers(session, 8, ((Row)object6).getData(), objectArray2, (int[])object5);
        }
        if (table.isView) {
            return n2;
        }
        rowSetNavigatorDataChange.beforeFirst();
        boolean bl2 = false;
        for (n = 0; n < rowSetNavigatorDataChange.getSize(); ++n) {
            object5 = rowSetNavigatorDataChange.getNextRow();
            objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
            object4 = (Table)((Row)object5).getTable();
            session.addDeleteAction((Table)object4, (Row)object5, null);
            if (objectArray == null) continue;
            bl2 = true;
        }
        rowSetNavigatorDataChange.beforeFirst();
        if (bl2) {
            for (n = 0; n < rowSetNavigatorDataChange.getSize(); ++n) {
                object5 = rowSetNavigatorDataChange.getNextRow();
                objectArray = rowSetNavigatorDataChange.getCurrentChangedData();
                object4 = (Table)((Row)object5).getTable();
                object3 = rowSetNavigatorDataChange.getCurrentChangedColumns();
                object2 = ((Table)object4).getRowStore(session);
                if (objectArray == null) continue;
                object = ((Table)object4).insertSingleRow(session, (PersistentStore)object2, objectArray, (int[])object3);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        BaseHashMap baseHashMap = null;
        object5 = null;
        boolean bl3 = bl = table.triggerLists[4].length > 0;
        if (n2 != rowSetNavigatorDataChange.getSize()) {
            while (rowSetNavigatorDataChange.hasNext()) {
                rowSetNavigatorDataChange.next();
                object4 = rowSetNavigatorDataChange.getCurrentRow();
                object3 = rowSetNavigatorDataChange.getCurrentChangedData();
                object2 = rowSetNavigatorDataChange.getCurrentChangedColumns();
                object = (Table)((Row)object4).getTable();
                if (object3 != null) {
                    StatementDML.performIntegrityChecks(session, (Table)object, ((Row)object4).getData(), (Object[])object3, (int[])object2);
                }
                if (object == table) continue;
                if (object3 == null) {
                    if (((Table)object).triggerLists[4].length > 0) {
                        bl = true;
                    }
                    if (object5 == null) {
                        object5 = new OrderedHashSet();
                    }
                    ((HashSet)object5).add(object);
                    continue;
                }
                if (((Table)object).triggerLists[5].length > 0) {
                    bl = true;
                }
                if (baseHashMap == null) {
                    baseHashMap = new OrderedHashSet();
                }
                ((HashSet)baseHashMap).add(object);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        if (bl) {
            while (rowSetNavigatorDataChange.hasNext()) {
                rowSetNavigatorDataChange.next();
                object4 = rowSetNavigatorDataChange.getCurrentRow();
                object3 = rowSetNavigatorDataChange.getCurrentChangedData();
                object2 = (Table)((Row)object4).getTable();
                if (object3 == null) {
                    ((Table)object2).fireTriggers(session, 4, ((Row)object4).getData(), null, null);
                    continue;
                }
                ((Table)object2).fireTriggers(session, 5, ((Row)object4).getData(), (Object[])object3, null);
            }
            rowSetNavigatorDataChange.beforeFirst();
        }
        table.fireTriggers(session, 1, rowSetNavigatorDataChange);
        if (baseHashMap != null) {
            for (int i = 0; i < baseHashMap.size(); ++i) {
                object3 = (Table)((OrderedHashSet)baseHashMap).get(i);
                ((Table)object3).fireTriggers(session, 2, rowSetNavigatorDataChange);
            }
        }
        if (object5 != null) {
            for (int i = 0; i < ((BaseHashMap)object5).size(); ++i) {
                object3 = (Table)((OrderedHashSet)object5).get(i);
                ((Table)object3).fireTriggers(session, 1, rowSetNavigatorDataChange);
            }
        }
        return n2;
    }

    static void performIntegrityChecks(Session session, Table table, Object[] objectArray, Object[] objectArray2, int[] nArray) {
        int n;
        if (objectArray2 == null) {
            return;
        }
        int n2 = table.checkConstraints.length;
        for (n = 0; n < n2; ++n) {
            table.checkConstraints[n].checkInsert(session, table, objectArray2, objectArray == null);
        }
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        n2 = table.fkConstraints.length;
        for (n = 0; n < n2; ++n) {
            boolean bl = objectArray == null;
            Constraint constraint = table.fkConstraints[n];
            if (!bl) {
                bl = ArrayUtil.haveCommonElement(constraint.getRefColumns(), nArray);
            }
            if (!bl) continue;
            constraint.checkInsert(session, table, objectArray2, objectArray == null);
        }
    }

    static void performReferentialActions(Session session, Table table, RowSetNavigatorDataChange rowSetNavigatorDataChange, Row row, Object[] objectArray, int[] nArray, HashSet hashSet) {
        if (!session.database.isReferentialIntegrity()) {
            return;
        }
        boolean bl = objectArray == null;
        for (Constraint constraint : table.fkMainConstraints) {
            int n;
            int n2 = n = bl ? constraint.core.deleteAction : constraint.core.updateAction;
            if (!bl && (!ArrayUtil.haveCommonElement(nArray, constraint.core.mainCols) || constraint.core.mainIndex.compareRowNonUnique(session, row.getData(), objectArray, constraint.core.mainCols) == 0)) continue;
            RowIterator rowIterator = constraint.findFkRef(session, row.getData());
            if (!rowIterator.hasNext()) {
                rowIterator.release();
                continue;
            }
            block12: while (rowIterator.hasNext()) {
                Object[] objectArray2;
                Row row2 = rowIterator.getNextRow();
                Object[] objectArray3 = null;
                if (constraint.core.refIndex.compareRowNonUnique(session, row2.getData(), row.getData(), constraint.core.mainCols) != 0) break;
                if (bl && row2.getId() == row.getId()) continue;
                switch (n) {
                    case 0: {
                        int n3;
                        if (bl) {
                            try {
                                n3 = rowSetNavigatorDataChange.addRow(row2);
                            }
                            catch (HsqlException hsqlException) {
                                Object[] objectArray4 = StatementDML.getConstraintInfo(constraint);
                                rowIterator.release();
                                throw Error.error(null, 3900, 2, objectArray4);
                            }
                            if (n3 == 0) continue block12;
                            StatementDML.performReferentialActions(session, constraint.core.refTable, rowSetNavigatorDataChange, row2, null, null, hashSet);
                            continue block12;
                        }
                        objectArray3 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray3, 0, objectArray3.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            objectArray3[constraint.core.refCols[n3]] = objectArray[constraint.core.mainCols[n3]];
                        }
                        break;
                    }
                    case 2: {
                        int n3;
                        objectArray3 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray3, 0, objectArray3.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            objectArray3[constraint.core.refCols[n3]] = null;
                        }
                        break;
                    }
                    case 4: {
                        int n3;
                        objectArray3 = constraint.core.refTable.getEmptyRowData();
                        System.arraycopy(row2.getData(), 0, objectArray3, 0, objectArray3.length);
                        for (n3 = 0; n3 < constraint.core.refCols.length; ++n3) {
                            objectArray2 = constraint.core.refTable.getColumn(constraint.core.refCols[n3]);
                            objectArray3[constraint.core.refCols[n3]] = objectArray2.getDefaultValue(session);
                        }
                        break;
                    }
                    case 3: {
                        if (rowSetNavigatorDataChange.containsDeletedRow(row2)) continue block12;
                    }
                    case 1: {
                        int n3 = constraint.core.deleteAction == 3 ? 8 : 3501;
                        objectArray2 = StatementDML.getConstraintInfo(constraint);
                        rowIterator.release();
                        throw Error.error(null, n3, 2, objectArray2);
                    }
                    default: {
                        continue block12;
                    }
                }
                try {
                    objectArray3 = rowSetNavigatorDataChange.addRow(session, row2, objectArray3, constraint.core.refTable.getColumnTypes(), constraint.core.refCols);
                }
                catch (HsqlException hsqlException) {
                    objectArray2 = StatementDML.getConstraintInfo(constraint);
                    rowIterator.release();
                    throw Error.error(null, 3900, 2, objectArray2);
                }
                if (objectArray3 == null || !hashSet.add(constraint)) continue;
                StatementDML.performReferentialActions(session, constraint.core.refTable, rowSetNavigatorDataChange, row2, objectArray3, constraint.core.refCols, hashSet);
                hashSet.remove(constraint);
            }
            rowIterator.release();
        }
    }

    static String[] getConstraintInfo(Constraint constraint) {
        return new String[]{constraint.core.refName.name, constraint.core.refTable.getName().name};
    }
}

